<?php
$default_settings = [
    'cms_animate' => '',
    'title_text' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = etc_get_element_id($settings);

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );
    $icon_tag = 'a';

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( 'link' );

$widget->add_render_attribute( 'description_text', 'class', 'custom-description' );
$widget->add_inline_editing_attributes( 'description_text' );

$time_to = $settings['time_to'];
?>
<div class="cms-count-down layout3 <?php echo esc_attr($cms_animate); ?>">
    <div class="item-box-title">
        <?php if(!empty($settings['title_text'])) : ?>
            <h3 class="item--title">
               <?php if(!empty($link_attributes)) { ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                    <?php echo wp_kses_post($settings['title_text']); ?>    
                <?php if(!empty($link_attributes)) { ?></a><?php } ?>
            </h3>
        <?php endif; ?>
        <?php if(!empty($settings['description_text'])) : ?>
            <div <?php etc_print_html($widget->get_render_attribute_string( 'description_text' )); ?>>
                <?php echo wp_kses_post($settings['description_text']); ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="cms-count-down-container font-smooth" data-time="<?php echo esc_attr($time_to); ?>">
        <div class="time-item">
            <div class="inner-text"><?php echo esc_html__('Days', 'nuvo') ?></div>
            <div class="day inner-number"></div>
        </div>
        <div class="time-item">
            <div class="inner-text"><?php echo esc_html__('Hours', 'nuvo') ?></div>
            <div class="hour inner-number"></div>
        </div>
        <div class="time-item">
            <div class="inner-text"><?php echo esc_html__('Minutes', 'nuvo') ?></div>
            <div class="minute inner-number"></div>
        </div>
        <div class="time-item">
            <div class="inner-text"><?php echo esc_html__('Seconds', 'nuvo') ?></div>
            <div class="second inner-number"></div>
        </div>
    </div>
</div>
