<?php
/**
 * The header for our theme.
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @package Nuvo
 */
$bg_url = '';
$bg_site_content = nuvo_get_opt( 'bg_site_content' );
$bg_url = !empty($bg_site_content['url']) ? $bg_site_content['url'] : '';

$page_bg_site_content = nuvo_get_page_opt( 'bg_site_content' );
$bg_url = !empty($page_bg_site_content['url']) ? $page_bg_site_content['url'] : $bg_url;

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="//gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> <?php if(!empty($bg_url)) : ?>style="background-image: url(<?php echo esc_url($bg_url); ?>);"<?php endif; ?>>
    <?php wp_body_open(); ?>
    <div id="page" class="site">
        <?php 
        	nuvo_page_loading();
        	nuvo_header_layout();
            nuvo_page_title_layout();
        ?>
        <div id="content" class="site-content">
        	<div class="content-inner">
