<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Nuvo
 */

/**
 * Setup default image sizes after the theme has been activated
 */
function nuvo_after_setup_theme()
{

}
add_action( 'after_setup_theme', 'nuvo_after_setup_theme' );

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function nuvo_body_classes( $classes )
{   
    // Adds a class of group-blog to blogs with more than 1 published author.
    if (is_multi_author()) {
        $classes[] = 'group-blog';
    }

    // Adds a class of hfeed to non-singular pages.
    if (!is_singular()) {
        $classes[] = 'hfeed';
    }
    if (class_exists('ReduxFramework')) {
        $site_boxed = false;
        if (nuvo_get_opt( 'site_boxed', 'show' ) == 'show') {
            $site_boxed = true;
        }
        else{
            if(nuvo_get_page_opt('site_boxed', 'themeoption') == 'show'){
                $site_boxed = true;
            }
        }
        if($site_boxed){
            $classes[] = 'site-boxed';
        }

        /* -- site rustic ---*/
        $site_rustic = false;
        if (nuvo_get_opt( 'site_rustic', 'show' ) == 'show') {
            $site_rustic = true;
        }
        else{
            if(nuvo_get_page_opt('site_rustic', 'themeoption') == 'show'){
                $site_rustic = true;
            }
        }
        if($site_rustic){
            $classes[] = 'site-rustic';
        }
    }
    if (class_exists('ReduxFramework')) {
        $classes[] = 'redux-page';
    }

    $body_default_font = nuvo_get_opt( 'body_default_font', 'Open Sans' );
    $heading_default_font = nuvo_get_opt( 'heading_default_font', 'Open Sans' );

    if($body_default_font == 'Open Sans') {
        $classes[] = 'body-default-font';
    }

    if($heading_default_font == 'Open Sans') {
        $classes[] = 'heading-default-font';
    }

    if (nuvo_get_opt( 'sticky_on', false )) {
        $classes[] = 'header-sticky';
    }

    $header_layout = nuvo_get_opt( 'header_layout', '1' );
    $classes[] = ' site-h'.$header_layout;

    return $classes;
}
add_filter( 'body_class', 'nuvo_body_classes' );


/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 */
function nuvo_pingback_header()
{
    if ( is_singular() && pings_open() )
    {
        echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
    }
}
add_action( 'wp_head', 'nuvo_pingback_header' );
