<?php
if (!class_exists('ReduxFramework')) {
    return;
}
if (class_exists('ReduxFrameworkPlugin')) {
    remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
}

if(class_exists('Newsletter')) {
    $forms = array_filter( (array) get_option( 'newsletter_forms', array() ) );

    $newsletter_forms = array(
        'default' => esc_html__( 'Default Form', 'nuvo' )
    );

    if ( $forms )
    {
        $index = 1;
        foreach ( $forms as $key => $form )
        {
            $newsletter_forms[ $key ] = sprintf( esc_html__( 'Form %s', 'nuvo' ), $index );
            $index ++;
        }
    }
} else {
    $newsletter_forms = '';
}

$opt_name = nuvo_get_opt_name();
$theme = wp_get_theme();

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name'             => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name'         => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version'      => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type'            => class_exists('Elementor_Theme_Core') ? 'submenu' : '',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu'       => true,
    // Show the sections below the admin menu item or not
    'menu_title'           => esc_html__('Theme Options', 'nuvo'),
    'page_title'           => esc_html__('Theme Options', 'nuvo'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key'       => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography'     => false,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar'            => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon'       => 'dashicons-admin-generic',
    // Choose an icon for the admin bar menu
    'admin_bar_priority'   => 50,
    // Choose an priority for the admin bar menu
    'global_variable'      => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode'             => true,
    // Show the time the page took to load, etc
    'update_notice'        => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer'           => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    'show_options_object' => false,
    // OPTIONAL -> Give you extra features
    'page_priority'        => null,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent'          => class_exists('Elementor_Theme_Core') ? $theme->get('TextDomain') : '',
    // For a full list of options, visit: //codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions'     => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon'            => '',
    // Specify a custom URL to an icon
    'last_tab'             => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon'            => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug'            => 'theme-options',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults'        => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show'         => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark'         => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export'   => true,
    // Shows the Import/Export panel when not used as a field.

    // CAREFUL -> These options are for advanced use only
    'transient_time'       => 60 * MINUTE_IN_SECONDS,
    'output'               => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag'           => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.

    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database'             => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn'              => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.

    // HINTS
    'hints'                => array(
        'icon'          => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color'    => 'lightgray',
        'icon_size'     => 'normal',
        'tip_style'     => array(
            'color'   => 'red',
            'shadow'  => true,
            'rounded' => false,
            'style'   => '',
        ),
        'tip_position'  => array(
            'my' => 'top left',
            'at' => 'bottom right',
        ),
        'tip_effect'    => array(
            'show' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'mouseover',
            ),
            'hide' => array(
                'effect'   => 'slide',
                'duration' => '500',
                'event'    => 'click mouseleave',
            ),
        ),
    ),
    'templates_path'       => get_template_directory() . '/inc/templates/redux/'
);

Redux::SetArgs($opt_name, $args);

/*--------------------------------------------------------------
# General
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('General', 'nuvo'),
    'icon'   => 'el-icon-home',
    'fields' => array(
        array(
            'id'       => 'favicon',
            'type'     => 'media',
            'title'    => esc_html__('Favicon', 'nuvo'),
            'default' => ''
        ),
        array(
            'id'       => 'show_page_loading',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Page Loading', 'nuvo'),
            'subtitle' => esc_html__('Enable page loading effect when you load site.', 'nuvo'),
            'default'  => false
        ),

        array(
            'id'           => 'site_boxed',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Site Boxed', 'nuvo' ),
            'options'      => array(
                'show'  => esc_html__( 'On', 'nuvo' ),
                'hide'  => esc_html__( 'Off', 'nuvo' ),
            ),
            'default'      => 'hide',
        ),

        array(
            'id'           => 'site_rustic',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Site Rustic', 'nuvo' ),
            'options'      => array(
                'show'  => esc_html__( 'On', 'nuvo' ),
                'hide'  => esc_html__( 'Off', 'nuvo' ),
            ),
            'default'      => 'hide',
        ),


        array(
            'id'       => 'dev_mode',
            'type'     => 'switch',
            'title'    => esc_html__('Dev Mode (not recommended)', 'nuvo'),
            'description' => 'no minimize , generate css over time...',
            'default'  => false
        ),
    )
));

/*--------------------------------------------------------------
# Header
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Header', 'nuvo'),
    'icon'   => 'el-icon-website',
    'fields' => array(
        array(
            'id'       => 'header_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'nuvo'),
            'subtitle' => esc_html__('Select a layout for header.', 'nuvo'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
                '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
                '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
                '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
            ),
            'default'  => '1'
        ),
        array(
            'id'       => 'sticky_on',
            'type'     => 'switch',
            'title'    => esc_html__('Sticky Header', 'nuvo'),
            'subtitle' => esc_html__('Header will be sticked when applicable.', 'nuvo'),
            'default'  => false
        ),
        array(
            'id'       => 'search_icon',
            'type'     => 'switch',
            'title'    => esc_html__('Search Icon', 'nuvo'),
            'default'  => false
        ),
        array(
            'id'       => 'cart_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Cart Icon', 'nuvo'),
            'options'  => array(
                'show'  => esc_html__('Show', 'nuvo'),
                'hidden'  => esc_html__('Hidden', 'nuvo'),
            ),
            'default'  => 'show',
        ),
        array(
            'title' => esc_html__('Button', 'nuvo'),
            'type'  => 'section',
            'id' => 'header_hiden',
            'indent' => true,
            'subtitle' => esc_html__('Apply header layout 1.', 'nuvo'),
        ),
        array(
            'id' => 'btn_text1',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'nuvo'),
            'default' => '',
        ),
        array(
            'id' => 'btn_link1',
            'type' => 'text',
            'title' => esc_html__('Button Link', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'       => 'btn_icon1',
            'type'     => 'cms_iconpicker',
            'title'    => esc_html__('Button Icon', 'nuvo'),
            'default' => ''
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Top Bar', 'nuvo'),
    'icon'       => 'el el-website',
    'subsection' => true,
    'fields'     => array(
        array(
            'title' => esc_html__('Social', 'nuvo'),
            'type'  => 'section',
            'id' => 'header_social',
            'indent' => true,
        ),

        array(
            'id'      => 'h_social_facebook_url',
            'type'    => 'text',
            'title'   => esc_html__('Facebook URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_twitter_url',
            'type'    => 'text',
            'title'   => esc_html__('Twitter URL', 'nuvo'),
            'default' => '#',
        ),
        array(
            'id'      => 'h_social_inkedin_url',
            'type'    => 'text',
            'title'   => esc_html__('Inkedin URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_instagram_url',
            'type'    => 'text',
            'title'   => esc_html__('Instagram URL', 'nuvo'),
            'default' => '#',
        ),
        array(
            'id'      => 'h_social_google_url',
            'type'    => 'text',
            'title'   => esc_html__('Google URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_skype_url',
            'type'    => 'text',
            'title'   => esc_html__('Skype URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_pinterest_url',
            'type'    => 'text',
            'title'   => esc_html__('Pinterest URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_vimeo_url',
            'type'    => 'text',
            'title'   => esc_html__('Vimeo URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_youtube_url',
            'type'    => 'text',
            'title'   => esc_html__('Youtube URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_yelp_url',
            'type'    => 'text',
            'title'   => esc_html__('Yelp URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_tumblr_url',
            'type'    => 'text',
            'title'   => esc_html__('Tumblr URL', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'      => 'h_social_tripadvisor_url',
            'type'    => 'text',
            'title'   => esc_html__('Tripadvisor URL', 'nuvo'),
            'default' => '#',
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Logo', 'nuvo'),
    'icon'       => 'el el-picture',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'logo_light',
            'type'     => 'media',
            'title'    => esc_html__('Logo Light', 'nuvo'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-light.png'
            )
        ),
        array(
            'id'       => 'logo',
            'type'     => 'media',
            'title'    => esc_html__('Logo Dark', 'nuvo'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-dark.png'
            )
        ),
        array(
            'id'       => 'logo_mobile',
            'type'     => 'media',
            'title'    => esc_html__('Logo Tablet & Mobile', 'nuvo'),
             'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/logo-dark.png'
            )
        ),
        array(
            'id'       => 'logo_maxh',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max height', 'nuvo'),
            'subtitle' => esc_html__('Enter number.', 'nuvo'),
            'width'    => false,
            'unit'     => 'px'
        ),
        array(
            'id'       => 'logo_maxh_sm',
            'type'     => 'dimensions',
            'title'    => esc_html__('Logo Max height Tablet & Mobile', 'nuvo'),
            'subtitle' => esc_html__('Enter number.', 'nuvo'),
            'width'    => false,
            'unit'     => 'px'
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Navigation', 'nuvo'),
    'icon'       => 'el el-lines',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'font_menu',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Google Font', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'font-style'  => false,
            'font-weight'  => true,
            'text-align'  => false,
            'font-size'  => false,
            'line-height'  => false,
            'color'  => false,
            'output'      => array('.primary-menu > li > a, body .primary-menu .sub-menu li a'),
            'units'       => 'px',
        ),
        array(
            'id'       => 'menu_font_size',
            'type'     => 'text',
            'title'    => esc_html__('Font Size', 'nuvo'),
            'validate' => 'numeric',
            'desc'     => 'Enter number',
            'msg'      => 'Please enter number',
            'default'  => ''
        ),
        array(
            'id'       => 'menu_text_transform',
            'type'     => 'select',
            'title'    => esc_html__('Text Transform', 'nuvo'),
            'options'  => array(
                '' => esc_html__('Default', 'nuvo'),
                'uppercase' => esc_html__('Uppercase', 'nuvo'),
                'capitalize'  => esc_html__('Capitalize', 'nuvo'),
                'lowercase'  => esc_html__('Lowercase', 'nuvo'),
                'initial'  => esc_html__('Initial', 'nuvo'),
                'inherit'  => esc_html__('Inherit', 'nuvo'),
                'none'  => esc_html__('None', 'nuvo'),
            ),
            'default'  => ''
        ),
        array(
            'title' => esc_html__('Main Menu', 'nuvo'),
            'type'  => 'section',
            'id' => 'main_menu',
            'indent' => true
        ),
        array(
            'id'      => 'main_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Color', 'nuvo'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'title' => esc_html__('Sticky Menu', 'nuvo'),
            'type'  => 'section',
            'id' => 'sticky_menu',
            'indent' => true
        ),
        array(
            'id'      => 'sticky_menu_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Color', 'nuvo'),
            'default' => array(
                'regular' => '',
                'hover'   => '',
                'active'   => '',
            ),
        ),
        array(
            'title' => esc_html__('Button Navigation', 'nuvo'),
            'type'  => 'section',
            'id' => 'button_navigation',
            'indent' => true
        ),
        array(
            'id'       => 'h_btn_on',
            'type'     => 'button_set',
            'title'    => esc_html__('Show/Hide Button', 'nuvo'),
            'options'  => array(
                'show'  => esc_html__('Show', 'nuvo'),
                'hide'  => esc_html__('Hide', 'nuvo')
            ),
            'default'  => 'hide',
        ),
        array(
            'id' => 'h_btn_text',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'nuvo'),
            'default' => '',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_link_type',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Link Type', 'nuvo'),
            'options'  => array(
                'page'  => esc_html__('Page', 'nuvo'),
                'custom'  => esc_html__('Custom', 'nuvo')
            ),
            'default'  => 'page',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'    => 'h_btn_link',
            'type'  => 'select',
            'title' => esc_html__( 'Page Link', 'nuvo' ), 
            'data'  => 'page',
            'args'  => array(
                'post_type'      => 'page',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                'order'          => 'ASC',
            ),
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'page' ),
            'force_output' => true
        ),
        array(
            'id' => 'h_btn_link_custom',
            'type' => 'text',
            'title' => esc_html__('Custom Link', 'nuvo'),
            'default' => '',
            'required' => array( 0 => 'h_btn_link_type', 1 => 'equals', 2 => 'custom' ),
            'force_output' => true
        ),
        array(
            'id'       => 'h_btn_target',
            'type'     => 'button_set',
            'title'    => esc_html__('Button Target', 'nuvo'),
            'options'  => array(
                '_self'  => esc_html__('Self', 'nuvo'),
                '_blank'  => esc_html__('Blank', 'nuvo')
            ),
            'default'  => '_self',
            'required' => array( 0 => 'h_btn_on', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'btn_icon2',
            'type'     => 'cms_iconpicker',
            'title'    => esc_html__('Button Icon', 'nuvo'),
            'default' => ''
        ),
    )
));

/*--------------------------------------------------------------
# Page Title area
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Page Title', 'nuvo'),
    'icon'   => 'el-icon-map-marker',
    'fields' => array(

        array(
            'id'           => 'pagetitle',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Page Title', 'nuvo' ),
            'options'      => array(
                'show'  => esc_html__( 'Show', 'nuvo' ),
                'hide'  => esc_html__( 'Hide', 'nuvo' ),
            ),
            'default'      => 'show',
        ),

        array(
            'id'       => 'ptitle_layout',
            'type'     => 'image_select',
            'title'    => esc_html__('Layout', 'nuvo'),
            'subtitle' => esc_html__('Select a layout for page title.', 'nuvo'),
            'options'  => array(
                '1' => get_template_directory_uri() . '/assets/images/ptitle-layout/p1.jpg',
                '2' => get_template_directory_uri() . '/assets/images/ptitle-layout/p2.jpg',
                '3' => get_template_directory_uri() . '/assets/images/ptitle-layout/p3.jpg',
                '4' => get_template_directory_uri() . '/assets/images/ptitle-layout/p4.jpg',
                
            ),
            'default'  => '1',
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),

        array(
            'id'       => 'page_title_img',
            'type'     => 'media',
            'title'    => esc_html__('Page Title Image', 'nuvo'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),

        array(
            'id'       => 'ptitle_color',
            'type'     => 'color',
            'title'    => esc_html__('Title Color', 'nuvo'),
            'subtitle' => esc_html__('Page title color.', 'nuvo'),
            'output'   => array('body #pagetitle h1.entry-page-title'),
            'default'  => '',
            'transparent' => false,
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),

        array(
            'id' => 'title_font_size',
            'type' => 'text',
            'title' => esc_html__('Font Size', 'nuvo'),
            'validate' => 'numeric',
            'desc' => esc_html__('Enter number','nuvo'),
            'msg' => esc_html__('Please enter number','nuvo'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
            'default' => ''
        ),

        array(
            'id' => 'title_line_hegiht',
            'type' => 'text',
            'title' => esc_html__('Line Height', 'nuvo'),
            'validate' => 'numeric',
            'desc' => esc_html__('Enter number','nuvo'),
            'msg' => esc_html__('Please enter number','nuvo'),
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true,
            'default' => ''
        ),

        array(
            'id'           => 'breadcrumb',
            'type'         => 'button_set',
            'title'        => esc_html__( 'Breadcrumbs', 'nuvo' ),
            'options'      => array(
                'show'  => esc_html__( 'Show', 'nuvo' ),
                'hide'  => esc_html__( 'Hide', 'nuvo' ),
            ),
            'default'      => 'show',
            'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
            'force_output' => true
        ),
        array(
            'id'       => 'page_title_align',
            'type'     => 'button_set',
            'title'    => esc_html__('Content Align', 'nuvo'),
            'subtitle' => esc_html__('Apply for Layout 1 & 3', 'nuvo'),
            'options' => array(
                'left' => 'Left', 
                'center' => 'Center',
                'right' => 'Right',
             ), 
            'default' => 'center',
            'output'   => array('#pagetitle .page-title-inner'),
        ),
    )
));


/*--------------------------------------------------------------
# WordPress default content
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title' => esc_html__('Content', 'nuvo'),
    'icon'  => 'el-icon-pencil',
    'fields'     => array(
        array(
            'id'       => 'bg_site_content',
            'type'     => 'media',
            'title'    => esc_html__('Site Background Image', 'nuvo'),
        ),
        array(
            'id'       => 'content_bg_color',
            'type'     => 'color_rgba',
            'title'    => esc_html__('Background Color', 'nuvo'),
            'subtitle' => esc_html__('Content background color.', 'nuvo'),
            'output' => array('background-color' => 'body .site')
        ),
        array(
            'id'             => 'content_padding',
            'type'           => 'spacing',
            'output'         => array('#content'),
            'right'   => false,
            'left'    => false,
            'mode'           => 'padding',
            'units'          => array('px'),
            'units_extended' => 'false',
            'title'          => esc_html__('Content Padding', 'nuvo'),
            'desc'           => esc_html__('Default: Top-90px, Bottom-90px', 'nuvo'),
            'default'            => array(
                'padding-top'   => '',
                'padding-bottom'   => '',
                'units'          => 'px',
            )
        ),
        array(
            'id'      => 'search_field_placeholder',
            'type'    => 'text',
            'title'   => esc_html__('Search Form - Text Placeholder', 'nuvo'),
            'default' => '',
            'desc'           => esc_html__('Default: Search Keywords...', 'nuvo'),
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Archive', 'nuvo'),
    'icon'       => 'el-icon-list',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'       => 'archive_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'nuvo'),
            'subtitle' => esc_html__('Select a sidebar position for blog home, archive, search...', 'nuvo'),
            'options'  => array(
                'left'  => esc_html__('Left', 'nuvo'),
                'right' => esc_html__('Right', 'nuvo'),
                'none'  => esc_html__('Disabled', 'nuvo')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'archive_author_on',
            'title'    => esc_html__('Author', 'nuvo'),
            'subtitle' => esc_html__('Show author name on each post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_date_on',
            'title'    => esc_html__('Date', 'nuvo'),
            'subtitle' => esc_html__('Show date posted on each post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_categories_on',
            'title'    => esc_html__('Categories', 'nuvo'),
            'subtitle' => esc_html__('Show category names on each post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_comments_on',
            'title'    => esc_html__('Comments', 'nuvo'),
            'subtitle' => esc_html__('Show comments count on each post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true,
        ),
        array(
            'id'       => 'archive_favorite_on',
            'title'    => esc_html__('Favorite', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
    )
));


Redux::setSection($opt_name, array(
    'title'      => esc_html__('Single Post', 'nuvo'),
    'icon'       => 'el-icon-file-edit',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'post_bg_color',
            'type'        => 'color',
            'title'       => esc_html__('Content Background Color', 'nuvo'),
            'transparent' => false,
            'default'     => '',
            'required' => array( 0 => 'single_post_layout', 1 => 'equals', 2 => 'real-estate' ),
            'force_output' => true
        ),
        array(
            'id'       => 'post_sidebar_pos',
            'type'     => 'button_set',
            'title'    => esc_html__('Sidebar Position', 'nuvo'),
            'subtitle' => esc_html__('Select a sidebar position', 'nuvo'),
            'options'  => array(
                'left'  => esc_html__('Left', 'nuvo'),
                'right' => esc_html__('Right', 'nuvo'),
                'none'  => esc_html__('Disabled', 'nuvo')
            ),
            'default'  => 'right'
        ),
        array(
            'id'       => 'post_author_on',
            'title'    => esc_html__('Author', 'nuvo'),
            'subtitle' => esc_html__('Show author name on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_author_info_on',
            'title'    => esc_html__('Author Info', 'nuvo'),
            'subtitle' => esc_html__('Show author info name on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => false
        ),
        array(
            'id'       => 'post_date_on',
            'title'    => esc_html__('Date', 'nuvo'),
            'subtitle' => esc_html__('Show date on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_categories_on',
            'title'    => esc_html__('Categories', 'nuvo'),
            'subtitle' => esc_html__('Show category names on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_tags_on',
            'title'    => esc_html__('Tags', 'nuvo'),
            'subtitle' => esc_html__('Show tag names on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_comments_on',
            'title'    => esc_html__('Comments', 'nuvo'),
            'subtitle' => esc_html__('Show comments count on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => false
        ),
        array(
            'id'       => 'post_favorite_on',
            'title'    => esc_html__('Favorite', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
        array(
            'id'       => 'post_social_share_on',
            'title'    => esc_html__('Social Share', 'nuvo'),
            'subtitle' => esc_html__('Show social share on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => false,
        ),

        array(
            'id'       => 'post_feature_image_on',
            'title'    => esc_html__('Feature Image', 'nuvo'),
            'subtitle' => esc_html__('Show feature image on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),

        array(
            'id'       => 'post_navigation_on',
            'title'    => esc_html__('Navigation', 'nuvo'),
            'subtitle' => esc_html__('Show navigation on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => false,
        ),

        array(
            'id'       => 'post_comments_form_on',
            'title'    => esc_html__('Comments Form', 'nuvo'),
            'subtitle' => esc_html__('Show comments form on single post.', 'nuvo'),
            'type'     => 'switch',
            'default'  => true
        ),
    )
));
/*--------------------------------------------------------------
# Shop
--------------------------------------------------------------*/
if(class_exists('Woocommerce')) {
    Redux::setSection($opt_name, array(
        'title'  => esc_html__('Shop', 'nuvo'),
        'icon'   => 'el el-shopping-cart',
        'fields' => array(
            array(
                'id'       => 'sidebar_shop',
                'type'     => 'button_set',
                'title'    => esc_html__('Sidebar Position', 'nuvo'),
                'subtitle' => esc_html__('Select a sidebar position for archive shop.', 'nuvo'),
                'options'  => array(
                    'left'  => esc_html__('Left', 'nuvo'),
                    'right' => esc_html__('Right', 'nuvo'),
                    'none'  => esc_html__('Disabled', 'nuvo')
                ),
                'default'  => 'right'
            ),
            array(
                'title' => esc_html__('Products displayed per page', 'nuvo'),
                'id' => 'product_per_page',
                'type' => 'slider',
                'subtitle' => esc_html__('Number product to show', 'nuvo'),
                'default' => 8,
                'min'  => 4,
                'step' => 1,
                'max' => 50,
                'display_value' => 'text'
            ),
            array(
                'id'       => 'shop_page_title_img',
                'type'     => 'media',
                'title'    => esc_html__('Page Title Image', 'nuvo'),
                'required' => array( 0 => 'pagetitle', 1 => 'equals', 2 => 'show' ),
                'force_output' => true
            ),
        )
    ));
}


/*--------------------------------------------------------------
# Footer
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Footer', 'nuvo'),
    'icon'   => 'el el-website',
    'fields' => array(
        array(
            'id'          => 'footer_layout_custom',
            'type'        => 'select',
            'title'       => esc_html__('Layout', 'nuvo'),
            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','nuvo'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
            'options'     => nuvo_list_post('footer'),
            'default'     => '',
        ),
        array(
            'id'       => 'back_totop_on',
            'type'     => 'switch',
            'title'    => esc_html__('Back to Top Button', 'nuvo'),
            'subtitle' => esc_html__('Show back to top button when scrolled down.', 'nuvo'),
            'default'  => true,
        ),
    )
));

/*--------------------------------------------------------------
# Colors
--------------------------------------------------------------*/

Redux::setSection($opt_name, array(
    'title'  => esc_html__('Colors', 'nuvo'),
    'icon'   => 'el-icon-file-edit',
    'fields' => array(
        array(
            'id'          => 'primary_color',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color', 'nuvo'),
            'transparent' => false,
            'default'     => '#c79c60'
        ),
        array(
            'id'          => 'primary_color2',
            'type'        => 'color',
            'title'       => esc_html__('Primary Color 2', 'nuvo'),
            'transparent' => false,
            'default'     => '#a37b44'
        ),
        array(
            'id'          => 'secondary_color',
            'type'        => 'color',
            'title'       => esc_html__('Secondary Color', 'nuvo'),
            'transparent' => false,
            'default'     => '#222'
        ),
        array(
            'id'          => 'regular_color',
            'type'        => 'color',
            'title'       => esc_html__('Regular Color', 'nuvo'),
            'transparent' => false,
            'default'     => '#888'
        ),
        array(
            'id'      => 'link_color',
            'type'    => 'link_color',
            'title'   => esc_html__('Link Colors', 'nuvo'),
            'default' => array(
                'regular' => '#c79c60',
                'hover'   => '#a37b44',
                'active'  => '#a37b44'
            ),
            'output'  => array('a')
        )
    )
));

/*--------------------------------------------------------------
# Typography
--------------------------------------------------------------*/
$custom_font_selectors_1 = Redux::getOption($opt_name, 'custom_font_selectors_1');
$custom_font_selectors_1 = !empty($custom_font_selectors_1) ? explode(',', $custom_font_selectors_1) : array();
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Typography', 'nuvo'),
    'icon'   => 'el-icon-text-width',
    'fields' => array(
        array(
            'id'       => 'body_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Body Default Font', 'nuvo'),
            'options'  => array(
                'Open Sans'  => esc_html__('Default', 'nuvo'),
                'Google-Font'  => esc_html__('Google Font', 'nuvo'),
            ),
            'default'  => 'Open Sans',
        ),
        array(
            'id'          => 'font_main',
            'type'        => 'typography',
            'title'       => esc_html__('Body Google Font', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'line-height'  => true,
            'font-size'  => true,
            'text-align'  => false,
            'output'      => array('body'),
            'units'       => 'px',
            'required' => array( 0 => 'body_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'       => 'heading_default_font',
            'type'     => 'select',
            'title'    => esc_html__('Heading Default Font', 'nuvo'),
            'options'  => array(
                'Open Sans'  => esc_html__('Default', 'nuvo'),
                'Google-Font'  => esc_html__('Google Font', 'nuvo'),
            ),
            'default'  => 'Open Sans',
        ),
        array(
            'id'          => 'font_h1',
            'type'        => 'typography',
            'title'       => esc_html__('H1', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H1 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h1', '.h1', '.text-heading'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h2',
            'type'        => 'typography',
            'title'       => esc_html__('H2', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H2 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h2', '.h2'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h3',
            'type'        => 'typography',
            'title'       => esc_html__('H3', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H3 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h3', '.h3'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h4',
            'type'        => 'typography',
            'title'       => esc_html__('H4', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H4 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h4', '.h4'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h5',
            'type'        => 'typography',
            'title'       => esc_html__('H5', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H5 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h5', '.h5'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
        array(
            'id'          => 'font_h6',
            'type'        => 'typography',
            'title'       => esc_html__('H6', 'nuvo'),
            'subtitle'    => esc_html__('This will be the default font for all H6 tags of your website.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => array('h6', '.h6'),
            'units'       => 'px',
            'required' => array( 0 => 'heading_default_font', 1 => 'equals', 2 => 'Google-Font' ),
            'force_output' => true
        ),
    )
));

Redux::setSection($opt_name, array(
    'title'      => esc_html__('Fonts Selectors', 'nuvo'),
    'icon'       => 'el el-fontsize',
    'subsection' => true,
    'fields'     => array(
        array(
            'id'          => 'custom_font_1',
            'type'        => 'typography',
            'title'       => esc_html__('Custom Font', 'nuvo'),
            'subtitle'    => esc_html__('This will be the font that applies to the class selector.', 'nuvo'),
            'google'      => true,
            'font-backup' => true,
            'all_styles'  => true,
            'text-align'  => false,
            'output'      => $custom_font_selectors_1,
            'units'       => 'px',

        ),
        array(
            'id'       => 'custom_font_selectors_1',
            'type'     => 'textarea',
            'title'    => esc_html__('CSS Selectors', 'nuvo'),
            'subtitle' => esc_html__('Add class selectors to apply above font.', 'nuvo'),
            'validate' => 'no_html'
        )
    )
));

/* Google Maps /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Google Maps', 'nuvo'),
    'icon'   => 'el el-map-marker',
    'fields' => array(
        array(
            'id'       => 'gm_api_key',
            'type'     => 'text',
            'title'    => esc_html__('API Key', 'nuvo'),
            'default' => 'AIzaSyC08_qdlXXCWiFNVj02d-L2BDK5qr6ZnfM',
            'desc' => esc_html__('Register a Google Maps Api key then put it in here.', 'nuvo')
        ),
    ),
));

/* 404 Page /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('404 Page', 'nuvo'),
    'icon'   => 'el-cog-alt el',
    'fields' => array(
        array(
            'id'       => 'img_404',
            'type'     => 'media',
            'title'    => esc_html__('Image 404', 'nuvo'),
            'subtitle' => esc_html__('Select image for page 404', 'nuvo'),
            'default' => array(
                'url'=>get_template_directory_uri().'/assets/images/image-404.png'
            )
        ),
        array(
            'id'       => 'content_404_page',
            'type'     => 'textarea',
            'title'    => esc_html__('Content', 'nuvo'),
            'default' => '',
        ),
        array(
            'id'       => 'btn_text_404_page',
            'type'     => 'text',
            'title'    => esc_html__('Button Text', 'nuvo'),
            'default' => '',
            'desc' => esc_html__('Default: Take me go back home', 'nuvo')
        ),
    ),
));

/* Custom Code /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom Code', 'nuvo'),
    'icon'   => 'el-icon-edit',
    'fields' => array(

        array(
            'id'       => 'site_header_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Header Custom Codes', 'nuvo'),
            'subtitle' => esc_html__('It will insert the code to wp_head hook.', 'nuvo'),
        ),
        array(
            'id'       => 'site_footer_code',
            'type'     => 'textarea',
            'theme'    => 'chrome',
            'title'    => esc_html__('Footer Custom Codes', 'nuvo'),
            'subtitle' => esc_html__('It will insert the code to wp_footer hook.', 'nuvo'),
        ),

    ),
));

/* Custom CSS /--------------------------------------------------------- */
Redux::setSection($opt_name, array(
    'title'  => esc_html__('Custom CSS', 'nuvo'),
    'icon'   => 'el-icon-adjust-alt',
    'fields' => array(

        array(
            'id'   => 'customcss',
            'type' => 'info',
            'desc' => esc_html__('Custom CSS', 'nuvo')
        ),

        array(
            'id'       => 'site_css',
            'type'     => 'ace_editor',
            'title'    => esc_html__('CSS Code', 'nuvo'),
            'subtitle' => esc_html__('Advanced CSS Options. You can paste your custom CSS Code here.', 'nuvo'),
            'mode'     => 'css',
            'validate' => 'css',
            'theme'    => 'chrome',
            'default'  => ""
        ),

    ),
));