<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Nuvo
 */
$post_tags_on = nuvo_get_opt( 'post_tags_on', true );
$post_navigation_on = nuvo_get_opt( 'post_navigation_on', false );
$post_author_info_on = nuvo_get_opt( 'post_author_info_on', false );
$post_social_share_on = nuvo_get_opt( 'post_social_share_on', false );
$post_feature_image_on = nuvo_get_opt( 'post_feature_image_on', true );
$post_date_on = nuvo_get_opt( 'post_date_on', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry'); ?>>
    <div class="wp-title">
        <div class="wp-meta-top">
            <?php if($post_date_on) : ?>
                <span class="item-date">
                    <span class="date1"><?php echo get_the_date('j'); ?></span>
                    <span class="date2"><?php echo get_the_date('M'); ?></span>
                </span>
            <?php endif; ?>
            <div class="meta-icon">
                <i class="<?php if(is_sticky()){ echo "fa fa-thumb-tack"; } else { echo nuvo_get_icon_post_type();} ?>"></i>
            </div>
        </div>            
        <h2 class="entry-title">
            <?php the_title(); ?>
        </h2>
    </div>
    <?php if (has_post_format('gallery')) : ?>
        <div class="entry-featured entry-gallery">
            <?php
                $light_box = nuvo_get_post_format_value('post-gallery-lightbox', '0');
                $gallery_list = explode(',', nuvo_get_post_format_value('post-gallery-images', ''));
                wp_enqueue_script('jquery-slick');
                wp_enqueue_script('nuvo-carousel');
            ?>
            <div class="cms-slick-carousel  <?php if($light_box) {echo 'images-light-box';} ?>" data-arrows="true"  data-autoplay="1" data-autoplayspeed="5000" data-infinite="0" data-speed="500" data-slidestoshow="1" data-slidestoshowtablet="1" data-slidestoshowmobile="1" data-slidestoscroll="1" data-slidestoscrolltablet="1" data-slidestoscrollmobile="1">
                <?php
                foreach ($gallery_list as $img_id):
                    ?>
                    <div class="slick-slide">
                        <a class="light-box" href="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'full'));?>"><img src="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'nuvo-large'));?>" alt="<?php echo esc_attr(get_post_meta( $img_id, '_wp_attachment_image_alt', true )) ?>"></a>
                    </div>
                    <?php
                endforeach;
                ?>
            </div>
        </div>
    <?php elseif (has_post_format('quote')) : ?>
        <div class="entry-featured entry-quote">
            <div class="entry-quote-inner">
            <?php
                $quote_text = nuvo_get_post_format_value('post-quote-cite', '');
                echo esc_attr($quote_text);
            ?>
            </div>
        </div>
    <?php elseif (has_post_format('link')) : ?>
        <div class="entry-featured entry-link">
            <?php
                $link_pf = nuvo_get_post_format_value('post-link-url', '#');
                echo esc_url($link_pf);
            ?>
        </div>
    <?php elseif (has_post_format('video')) : ?>
        <div class="entry-featured entry-video">
            <div class="entry-video featured-active">
                <?php
                $video_url = nuvo_get_post_format_value('post-video-url', '#');
                $video_file = nuvo_get_post_format_value('post-video-file', '');
                $video_html = nuvo_get_post_format_value('post-video-html', '');
                $video = '';
                if (!empty($video_url)) {
                    global $wp_embed;
                    echo do_shortcode($wp_embed->run_shortcode('[embed]' . $video_url . '[/embed]'));
                } elseif (!empty($video_file)) {
                    if (strpos('[embed', $video_file)) {
                        global $wp_embed;
                        echo do_shortcode($wp_embed->run_shortcode($video_file));
                    } else {
                        echo do_shortcode($video_file);
                    }
                } else {
                    if ('' != $video_html) {
                        echo do_shortcode($video_html);
                    }
                }
                ?>
            </div>
        </div>
    <?php elseif (has_post_format('audio')) : ?>
        <div class="entry-featured entry-audio">
            <?php
                $audio_url = nuvo_get_post_format_value('post-audio-url', '#');
                echo esc_url($audio_url);
            ?>
        </div>
    <?php else :
        if (has_post_thumbnail() && $post_feature_image_on == true) {
            echo '<div class="entry-featured entry-image"><div class="post-image">'; ?>
                <?php the_post_thumbnail('nuvo-large'); ?>
            <?php echo '</div></div>';
        } ?>
    <?php endif; ?>
    <div class="entry-body">
        <?php nuvo_post_meta(); ?>
        <div class="entry-content clearfix">
            <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div><!-- .entry-content -->
    </div>
    <?php if($post_social_share_on) {
        nuvo_socials_share_default();
    } ?>
    <?php if($post_tags_on) :
        nuvo_entry_tagged_in();
    endif; ?>
    <div class="gap-el"></div>
    <?php if($post_navigation_on) : ?>
        <div class="entry-navigation">
            <?php nuvo_post_nav_default(); ?>
        </div>
    <?php endif; ?>
    <?php if($post_author_info_on) : ?>
        <div class="entry-author-info">
            <div class="author-post">
                <div class="author-avatar">
                        <?php echo get_avatar( get_the_author_meta( 'ID' ), 'full' ); ?>
                    </div>
                <div class="author-description">
                    <div class="author-name">
                        <?php the_author_posts_link(); ?>
                    </div>
                    <p>
                        <?php the_author_meta( 'description' ); ?>
                    </p>
                    <?php nuvo_get_user_social(); ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
</article><!-- #post -->