<?php
/**
 * Template part for displaying default header layout
 */

$sticky_on = nuvo_get_opt( 'sticky_on', false );
$search_icon = nuvo_get_opt( 'search_icon', false );

$cart_on = nuvo_get_opt( 'cart_on', 'show' );
$page_cart_on = nuvo_get_page_opt( 'cart_on', 'themeoption');
if($page_cart_on != 'themeoption') {
    $cart_on = $page_cart_on;
}

$btn_text1 = nuvo_get_opt( 'btn_text1' );
$btn_link1 = nuvo_get_opt( 'btn_link1' );
$btn_icon1 = nuvo_get_opt( 'btn_icon1' );

?>
<header id="masthead" class="site-header">
    <div id="site-header-wrap" class="header-layout1 <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">
        <?php if (class_exists('ReduxFramework')) { ?>
            <div id="site-header-top" class="site-header-top">
                <div class="container">
                    <div class="row">
                        <div class="site-header-socials">
                           <?php nuvo_social_header(); ?>
                        </div>
                        <?php if(!empty($btn_text1)) : ?>
                            <div class="site-header-button">
                                <a class="site-btn" href="<?php echo esc_url($btn_link1); ?>" target="_blank">
                                    <?php if(!empty($btn_icon1)) { ?>
                                        <i class="<?php echo esc_attr($btn_icon1); ?>"></i>
                                    <?php } ?>
                                    <?php echo esc_attr($btn_text1); ?>        
                                </a>
                            </div>
                        <?php endif; ?>

                        <?php if(class_exists('Woocommerce') && $cart_on == 'show') : ?>
                            <div class="site-header-cart">
                                <i class="fac fac-shopping-cart"></i>
                                <span class="widget_cart_counter_header"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'nuvo' ), WC()->cart->cart_contents_count ); ?></span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div id="site-header" class="site-header-main">
            <div class="container">
                <div class="row">
                    <div class="site-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="site-navigation">
                        <nav class="main-navigation">
                            <?php get_template_part( 'template-parts/header-menu' ); ?>
                        </nav>
                    </div>
                    <?php if($search_icon) : ?>
                        <div class="site-header-right">
                            <div class="site-header-item site-header-search">
                                <span class="h-btn-search"><i class="fac fac-search"></i></span>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div id="main-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>