(function($) {
    "use strict";
    $(document).ready(function () {
        var breakpoints = elementorFrontend.config.breakpoints;
        var carousels = $(".cms-slick-carousel");
        $.each(carousels, function (index, carousel) {
            carousel = $(carousel);
            var data = carousel.data();
            var slickOptions = {
                slidesToShow: data.slidestoshow,
                slidesToScroll: data.slidestoscroll,
                autoplay: true === data.autoplay,
                autoplaySpeed: data.autoplayspeed,
                infinite: true === data.infinite,
                pauseOnHover: true === data.pauseonhover,
                speed: data.speed,
                centerPadding: data.centerpadding,
                arrows: true === data.arrows,
                dots: true === data.dots,
                rtl: 'rtl' === data.dir,
                nextArrow: '<span class="slick-next fac fac-arrow-right"></span>',
                prevArrow: '<span class="slick-prev fac fac-arrow-left"></span>',
                responsive: [{
                    breakpoint: breakpoints.lg,
                    settings: {
                        slidesToShow: data.slidestoshowtablet,
                        slidesToScroll: data.slidestoscrolltablet,
                    }
                }, {
                    breakpoint: breakpoints.md,
                    settings: {
                        slidesToShow: data.slidestoshowmobile,
                        slidesToScroll: data.slidestoscrollmobile,
                        centerPadding: '0px',
                    }
                }]
            };
            if(typeof carousel.attr('data-centerMode') !== 'undefined') {
                slickOptions.centerMode = carousel.attr('data-centerMode') == 'true' ? true : false;
            }
            var nav_for = carousel.parent().find(".cms-slick-nav");
            if(nav_for.length > 0){
                slickOptions.asNavFor = nav_for;
            }
            carousel.slick(slickOptions);
        });

        $('.cms-nav-carousel').parents('.elementor-element').addClass('hide-nav');
        $('.cms-slick-nav-arrow').parents('.elementor-element').addClass('hide-nav');

        $('.cms-nav-carousel .slick-prev, .cms-slick-nav-left').on('click', function () {
            $(this).parents('.elementor-element').find('.cms-slick-slider .slick-prev').trigger('click');
        });
        $('.cms-nav-carousel .slick-next, .cms-slick-nav-right').on('click', function () {
            $(this).parents('.elementor-element').find('.cms-slick-slider .slick-next').trigger('click');
        });
    });
}(jQuery));