;(function ($) {
    "use strict";
    /* ===================
     Page reload
     ===================== */
    var scroll_top;
    var window_height;
    var window_width;
    var scroll_status = '';
    var lastScrollTop = 0;
    $(window).on('load', function () {
        $(".cms-loader").fadeOut("slow");
        window_width = $(window).width();
        nuvo_col_offset();
        nuvo_header_sticky();
        nuvo_rtl();
        nuvo_scroll_to_top();
        nuvo_quantity_icon();
    });
    $(window).on('resize', function () {
        window_width = $(window).width();
        nuvo_col_offset();
    });

    $(window).on('scroll', function () {
        scroll_top = $(window).scrollTop();
        window_height = $(window).height();
        window_width = $(window).width();
        if (scroll_top < lastScrollTop) {
            scroll_status = 'up';
        } else {
            scroll_status = 'down';
        }
        lastScrollTop = scroll_top;
        nuvo_header_sticky();
        nuvo_scroll_to_top();
    });

    $.sep_grid_refresh = function (){
        $('.cms-grid-masonry').each(function () {
            var iso = new Isotope(this, {
                itemSelector: '.grid-item',
                percentPosition: true,
                masonry: {
                    columnWidth: '.grid-sizer',
                },
                containerStyle: null,
                stagger: 30,
                sortBy : 'name',
            });

            var filtersElem = $(this).parent().find('.grid-filter-wrap');
            filtersElem.on('click', function (event) {
                var filterValue = event.target.getAttribute('data-filter');
                iso.arrange({filter: filterValue});
            });

            var filterItem = $(this).parent().find('.filter-item');
            filterItem.on('click', function (e) {
                filterItem.removeClass('active');
                $(this).addClass('active');
            });

            var filtersSelect = $(this).parent().find('.select-filter-wrap');
            filtersSelect.change(function() {
                var filters = $(this).val();
                iso.arrange({filter: filters});
            });

            var orderSelect = $(this).parent().find('.select-order-wrap');
            orderSelect.change(function() {
                var e_order = $(this).val();
                if(e_order == 'asc') {
                    iso.arrange({sortAscending: false});
                }
                if(e_order == 'des') {
                    iso.arrange({sortAscending: true});
                }
            });

        });
    }

    $(document).on('click', '.h-btn-search', function () {
        $('.cms-modal-search').addClass('open');
        setTimeout(function(){
            $('.cms-modal-search input[name="s"]').focus();
        },1000);
    });

    // load more
    $('.cms-grid').each(function () {
        var _this_wrap = $(this);
        var html_id = _this_wrap.attr('id');

        $(document).on('click', '.cms-load-more', function(){
            var loadmore = $(this).data('loadmore');
            var _this = $(this).parents(".cms-grid");
            var layout_type = _this.data('layout');
            loadmore.paged = parseInt(_this.data('start-page')) +1;
            var _this_click = $(this);
            _this_click.find('i').attr('class', 'fa fa-refresh fa-spin');
            $.ajax({
                url: main_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'nuvo_load_more_post_grid',
                    settings: loadmore
                }
            })
            .done(function (res) {
                if(res.status == true) {
                    var html = $("<div></div>").html(res.data.html);
                    html.find(".grid-item").addClass("cms-animated");
                    html = html.html();
                    _this.find('.cms-grid-inner').append(html);
                    _this.data('start-page', res.data.paged);
                    if(layout_type == 'masonry'){
                        _this.imagesLoaded(function() {
                            $.sep_grid_refresh();
                        });
                    }
                    if(res.data.paged >= res.data.max){
                        _this_click.hide();
                    }
                }
            })
            .fail(function (res) {
                return false;
            })
            .always(function () {
                _this_click.find('i').attr('class', 'i-hidden');
                return false;
            });
        });

        // pagination
        $(document).on('click', '.cms-grid-pagination .ajax a.page-numbers', function(){
            var _this = $(this).parents(".cms-grid");
            var loadmore = _this.find(".cms-grid-pagination").data('loadmore');
            var query_vars = _this.find(".cms-grid-pagination").data('query');
            var layout_type = _this.data('layout');
            var paged = $(this).attr('href');
            paged = paged.replace('#', '');
            loadmore.paged = parseInt(paged);
            query_vars.paged = parseInt(paged);
            // reload pagination
            $.ajax({
                url: main_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'nuvo_get_pagination_html',
                    query_vars: query_vars
                }
            }).done(function (res) {
                if(res.status == true){
                    _this.find(".cms-grid-pagination").html(res.data.html);
                }
            }).fail(function (res) {
                return false;
            }).always(function () {
                return false;
            });
            // load post
            $.ajax({
                url: main_data.ajax_url,
                type: 'POST',
                data: {
                    action: 'nuvo_load_more_post_grid',
                    settings: loadmore
                }
            }).done(function (res) {
                if(res.status == true){
                    _this.find('.cms-grid-inner .grid-item').remove();
                    _this.find('.cms-grid-inner').append(res.data.html);
                    _this.data('start-page', res.data.paged);
                    if(layout_type == 'masonry'){
                        _this.imagesLoaded(function() {
                            $.sep_grid_refresh();
                        });
                    }
                }
            }).fail(function (res) {
                return false;
            }).always(function () {
                return false;
            });
            return false;
        });
        
    });

    $(document).ready(function () {
        /* =================
         Menu Dropdown
         =================== */
        var $menu = $('.main-navigation');
        $menu.find('.primary-menu li').each(function () {
            var $submenu = $(this).find('> ul.sub-menu');
            if ($submenu.length == 1) {
                $(this).hover(function () {
                    if ($submenu.offset().left + $submenu.width() > $(window).width()) {
                        $submenu.addClass('back');
                    } else if ($submenu.offset().left < 0) {
                        $submenu.addClass('back');
                    }
                }, function () {
                    $submenu.removeClass('back');
                });
            }
        });

        $('.sub-menu .current-menu-item').parents('.menu-item-has-children').addClass('current-menu-ancestor');
        $('.mega-auto-width').parents('.megamenu').addClass('remove-pos');
        /* =================
         Menu Mobile
         =================== */
        $("#main-menu-mobile .open-menu").on('click', function () {
            $(this).toggleClass('opened');
            $('.site-navigation').toggleClass('navigation-open');
        });

        /* ===================
         Search Toggle
         ===================== */
        $('.h-btn-form').click(function (e) {
            e.preventDefault();
            $('.cms-modal-contact-form').removeClass('remove').toggleClass('open');
        });

        $('.cms-close').click(function (e) {
            e.preventDefault();
            $(this).parent().addClass('remove').removeClass('open');
            $(this).parents('.cms-modal').addClass('remove').removeClass('open');
            $(this).parents('.cms-widget-cart-wrap').removeClass('open');
            $(this).parents('#page').find('.site-overlay').removeClass('open');
        });

        /* Video 16:9 */
        $('.entry-video iframe').each(function () {
            var v_width = $(this).width();

            v_width = v_width / (16 / 9);
            $(this).attr('height', v_width + 35);
        });
        /* Images Light Box - Gallery:True */
        $('.cms-images-light-box').each(function () {
            $(this).magnificPopup({
                delegate: 'a.cms-light-box',
                type: 'image',
                gallery: {
                    enabled: true
                },
                mainClass: 'mfp-fade',
            });
        });

        $('cms-image-light-box').each(function () {
            $(this).magnificPopup({
                delegate: 'a.cms-light-box',
                type: 'image',
                gallery: {
                    enabled: false
                },
                mainClass: 'mfp-fade',
            });
        });

        /* Video Light Box */
        $('.cms-video-button, .btn-video, .btn-video-slider, .btn-video-white, .btn-video-outline').magnificPopup({
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 160,
            preloader: false,
            fixedContentPos: false
        });
        
        /* ====================
         Scroll To Top
         ====================== */
        $('.scroll-top').click(function () {
            $('html, body').animate({scrollTop: 0}, 800);
            return false;
        });
        /* ===================
        Custome Contact form
        ===================== */       
        $( ".wpcf7-field-date" ).datepicker();
        /* =================
        Add Class
        =================== */
        $('.wpcf7-select').parent().addClass('wpcf7-menu');
        /* =================
         Row & VC Column Animation
         =================== */

        $('.animation-time').each(function () {
            var eltime = 100;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .grid-item > .wow').each(function (index, obj) {
                $(this).css('animation-delay', eltime + 'ms');
                if (_elt === index) {
                    eltime = 100;
                    _elt = _elt + elt_inner;
                } else {
                    eltime = eltime + 80;
                }
            });
        });

        $('.cms-list').each(function () {
            var eltime = 100;
            var elt_inner = $(this).children().length;
            var _elt = elt_inner - 1;
            $(this).find('> .wow').each(function (index, obj) {
                $(this).css('animation-delay', eltime + 'ms');
                if (_elt === index) {
                    eltime = 50;
                    _elt = _elt + elt_inner;
                } else {
                    eltime = eltime + 50;
                }
            });
        });
        /* =================
         The clicked item should be in center in owl carousel
         =================== */
        var $owl_item = $('.owl-active-click');
        $owl_item.children().each(function (index) {
            $(this).attr('data-position', index);
        });
        $(document).on('click', '.owl-active-click .owl-item > div', function () {
            $owl_item.trigger('to.owl.carousel', $(this).data('position'));
        });

        /* Select */
        $('select').each(function () {
            $(this).niceSelect();
        });

        /* Newsletter */
        $('.widget_newsletterwidget, form.newsletter').each(function () {
            var email_text = $(this).find('.tnp-field-email label').text();
            $(this).find('.tnp-field-email label').remove();
            $(this).find(".tnp-email").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", email_text);
                }
            });
            var firstname_text = $(this).find('.tnp-field-firstname label').text();
            $(this).find('.tnp-field-firstname label').remove();
            $(this).find(".tnp-firstname").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", firstname_text);
                }
            });
            var lastname_text = $(this).find('.tnp-field-lastname label').text();
            $(this).find('.tnp-field-lastname label').remove();
            $(this).find(".tnp-lastname").each(function (ev) {
                if (!$(this).val()) {
                    $(this).attr("placeholder", lastname_text);
                }
            });
        });

        /* Mobile Menu */
        $('.main-navigation li.menu-item-has-children').append('<span class="main-menu-toggle"></span>');
        $('.main-menu-toggle').on('click', function () {
            $(this).parent().find('> .sub-menu').toggleClass('submenu-open');
            $(this).parent().find('> .sub-menu').slideToggle();
        });

        $(".h-btn-sidebar").on('click', function (e) {
            e.preventDefault();
            $('.cms-hidden-sidebar').toggleClass('open');
        });

        $(".cms-hidden-overlay").on('click', function (e) {
            e.preventDefault();
            $('.cms-hidden-sidebar').removeClass('open');
        });

        $(".h-btn-popup").on('click', function (e) {
            e.preventDefault();
            $('.cms-header-popup-wrap').toggleClass('open');
        });

        $(".cms-hidden-close, .cms-menu-close").on('click', function (e) {
            e.preventDefault();
            $(this).parent().removeClass('open');
        });

        $(document).on('click', function (e) {
            if (e.target.className == 'cms-modal-close'){
                $(e.target).parents(".cms-modal-search").removeClass('open');
            }
        });

        /* =================
         Move Divider, Angled & Overlay for Row VC
         =================== */
        $('.entry-content > .vc_row').each(function () {
            var _el_overlay = $(this).find(".cms-row-overlay"),
                _row_overlay = _el_overlay.parents(".wpb_column");
            _row_overlay.before(_el_overlay.clone());
            _el_overlay.remove();
            $(this).find(".cms-row-overlay").parent().addClass('vc-row-overlay');

            var _el_divider = $(this).find(".row-divider"),
                _row_divider = _el_divider.parents(".wpb_column");
            _row_divider.before(_el_divider.clone());
            _el_divider.remove();
        });


        $('.cms-pointer1').each(function () {
            $(this).find('.cms-pointer-btn').on('click', function () {
                $(this).toggleClass('open');
                $(this).parents('.elementor-widget-wrap').find('.cms-pointer1 .cms-pointer-btn').removeClass('open');
                $(this).addClass('open');
            });
        });

        /* Cart Sidebar */
        $(".site-header-cart").on('click', function (e) {
            e.preventDefault();
            $('.cms-widget-cart-wrap').toggleClass('open');
            $('.cms-header-navigation').removeClass('navigation-open');
        });


        $(".cms-contact-close").on('click', function () {
            $(this).parent().remove();
        });

        $('.site-header-hidden .item--hidden').click(function (e) {
            e.preventDefault();
            $(this).parents('.site-header-hidden').hide('slow');
        });

        $(".btn-toggle").on('click', function (){
            $(this).parent().find(".box-content").slideToggle('500');
        });
        // Only for tabs with id="tabs"
        var _tabs = $('#tabs');
        var tabHold = _tabs.parent();
        _tabs.find('[data-toggle="tab"]').on('click', function (e) {
            e.preventDefault();
            var target = $(this).attr('href');

            // tab
            _tabs.find('li').removeClass('active');
            $(this).parent().addClass('active');

            // tab content
            tabHold.find('.tab-content .tab-pane').removeClass('active');
            $(target).addClass('active');
        });
    });

    $(".widget .widget-title").html(function(){
      var text= $(this).text().trim().split(" ");
      var first = text.shift();
      return (text.length > 0 ? "<span class='red'>"+ first + "</span> " : first) + text.join(" ");
    });


    /* =================
     Column Absolute
     =================== */
    function nuvo_col_offset() {
        var w_vc_row_lg = ($('#content').width() - 1200) / 2;
        var w_vc_row_lg_full = ($('#content section.elementor-element section.elementor-element').width() - 1200) / 2;
        if (window_width > 1200) {
            $('body:not(.rtl) .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg + 'px');
            $('body:not(.rtl) .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg + 'px');

            $('.rtl .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg + 'px');
            $('.rtl .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg + 'px');

            $('body:not(.rtl) .cms-row-full-width .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg_full + 'px');
            $('body:not(.rtl) .cms-row-full-width .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg_full + 'px');

            $('.rtl .cms-row-full-width .col-offset-left > .elementor-column-wrap > .elementor-widget-wrap').css('padding-right', w_vc_row_lg_full + 'px');
            $('.rtl .cms-row-full-width .col-offset-right > .elementor-column-wrap > .elementor-widget-wrap').css('padding-left', w_vc_row_lg_full + 'px');
            $('.cms-history-carousel1').css('padding-left', w_vc_row_lg + 'px');
        }
    }
    
    /*Js Tab Widget Recent Post Sidebar*/
    function openCity(evt, cityName) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tabcontent");
        for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
        }
        tablinks = document.getElementsByClassName("tablinks");
        for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");
        }
        document.getElementById(cityName).style.display = "block";
        evt.currentTarget.className += " active";
    }

    function nuvo_header_sticky() {
        var offsetTop = $('#site-header-wrap').outerHeight();
        var h_header = $('.fixed-height').outerHeight();
        var offsetTopAnimation = offsetTop + 200;
        if($('#site-header-wrap').hasClass('is-sticky')) {
            if (scroll_top > offsetTopAnimation) {
                $('#site-header').addClass('h-fixed');
            } else {
                $('#site-header').removeClass('h-fixed');   
            }
        }
        
        if (window_width > 992) {
            $('.fixed-height').css({
                'height': h_header
            });
        }

        $('.cms-navigation-menu1.ct-menu-fixed').each(function () {
            var adminbar_height = $('#wpadminbar').outerHeight();
            var secondary_menu_offset = $('.cms-navigation-offsettop').offset().top - adminbar_height;
            var h_secondary_menu = $(this).outerHeight();
            if (scroll_top > secondary_menu_offset) {
                $(this).addClass('is-sticky');
            } else {
                $(this).removeClass('is-sticky');
            }
            if (window_width > 992) {
                $('.cms-navigation-wrap').css({
                    'height': h_secondary_menu
                });
            }
        });
    }

    function nuvo_rtl() {
        /* =================
        RTL
        =================== */
        if ($('html').attr('dir') == 'rtl') {
            $('[data-vc-full-width="true"]').each(function (i, v) {
                $(this).css('right', $(this).css('left')).css('left', 'auto');
            });
        }
    }

    /* ====================
     Scroll To Top
     ====================== */
    function nuvo_scroll_to_top() {
        if (scroll_top < window_height) {
            $('.scroll-top').addClass('off').removeClass('on');
        }
        if (scroll_top > window_height) {
            $('.scroll-top').addClass('on').removeClass('off');
        }
    }

    /* ====================
     WooComerce Quantity
     ====================== */
    function nuvo_quantity_icon() {
        $('#content .quantity').append('<span class="quantity-icon"><i class="quantity-up fac fac-plus"></i><i class="quantity-down fac fac-minus"></i></span>');
        $('.quantity-up').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepUp();
        });
        $('.quantity-down').on('click', function () {
            $(this).parents('.quantity').find('input[type="number"]').get(0).stepDown();
        });
        $('.woocommerce-cart-form .actions .button').removeAttr('disabled');
    }

    $( document ).ajaxComplete(function() {
       nuvo_quantity_icon();
    });

})(jQuery);
