<?php
// Register Icon Box Widget
etc_add_custom_widget(
    array(
        'name' => 'cms_countdown_time',
        'title' => esc_html__('Countdown Time', 'nuvo' ),
        'icon' => 'eicon-countdown',
        'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
        'scripts' => array(
            'cms-countdown-time-widget-js',
        ),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'nuvo' ),
                            'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown_time/layout-image/layout1.jpg'
                                ],
                                '2' => [
                                    'label' => esc_html__('Layout 2', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown_time/layout-image/layout2.jpg'
                                ],
                                '3' => [
                                    'label' => esc_html__('Layout 3', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown_time/layout-image/layout3.jpg'
                                ],
                                '4' => [
                                    'label' => esc_html__('Layout 4', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_countdown_time/layout-image/layout4.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'content_section',
                    'label' => esc_html__('Time to', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'title_text',
                            'label' => esc_html__('Title', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('This is the heading', 'nuvo' ),
                            'placeholder' => esc_html__('Enter your title', 'nuvo' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Title Link', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'condition' => [
                                'layout' => array('3'),
                            ],
                        ),
                        array(
                            'name' => 'description_text',
                            'label' => esc_html__('Description', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXTAREA,
                            'placeholder' => esc_html__('Enter your description', 'nuvo' ),
                            'rows' => 10,
                            'condition' => [
                                'layout' => array('2','3', '4'),
                            ],
                        ),
                        array(
                            'name' => 'time_to',
                            'label' => esc_html__('Enter the time', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::DATE_TIME,
                            'default' => '08/10/2021 00:00 AM',
                            'label_block' => true,
                            'description' => 'Time Format: 08/10/2021 00:00 AM'
                        ),
                    ),
                ),
                array(
                    'name' => 'section_banner',
                    'label' => esc_html__('Banner', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => array('4'),
                    ],
                    'controls' => array(
                        array(
                            'name' => 'image',
                            'label' => esc_html__('Choose Image', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::MEDIA,
                        ),
                        array(
                            'name' => 'thumbnail',
                            'label' => esc_html__('Image Size', 'nuvo' ),
                            'type' => \Elementor\Group_Control_Image_Size::get_type(),
                            'control_type' => 'group',
                            'default' => 'full',
                        ),
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                        ),
                        array(
                            'name' => 'button_link',
                            'label' => esc_html__('Link', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                        ),
                    ),
                ),
                array(
                    'name' => 'section_date_title',
                    'label' => esc_html__('Date Title Box', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'layout' => array('2'),
                    ],
                    'controls' => array(
                        array(
                            'name' => 'date_color',
                            'label' => esc_html__('Date Color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .item-date-feature' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'date_bottom_space',
                            'label' => esc_html__('Title Bottom Spacing', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'default' => [
                                'size' => 35,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .item-date-feature' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'date_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .item-date-feature',
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_title',
                    'label' => esc_html__('Title Box', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'condition' => [
                        'layout' => array('2', '3', '4'),
                    ],
                    'controls' => array(
                        array(
                            'name' => 'title_color',
                            'label' => esc_html__('Title Color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .item--title' => 'color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2', '3', '4'),
                            ],
                        ),
                        array(
                            'name' => 'title_bottom_space',
                            'label' => esc_html__('Title Bottom Spacing', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SLIDER,
                            'control_type' => 'responsive',
                            'size_units' => [ 'px' ],
                            'default' => [
                                'size' => 35,
                            ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 200,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .item--title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'layout' => array('2', '3', '4'),
                            ],
                        ),
                        array(
                            'name' => 'heading_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .cms-count-down .item--title',
                            'condition' => [
                                'layout' => array('2', '3', '4'),
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_number',
                    'label' => esc_html__('Countdown Number', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'number_background',
                            'label' => esc_html__('Number Background', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .inner-number' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('1', '2'),
                            ],
                        ),
                        array(
                            'name' => 'number_color',
                            'label' => esc_html__('Number Color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .inner-number' => 'color: {{VALUE}};',
                            ],
                        ),
                        // Day color setting
                        array(
                            'name' => 'background_color_item1',
                            'label' => esc_html__('Day - Border color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(1) .time-item-inner' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(1) .time-item-inner .inner-text' => 'border-top-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'background_color_day',
                            'label' => esc_html__('Day - Background Number', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(1) .time-item-inner .day' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        // Hours color setting
                        array(
                            'name' => 'background_color_item2',
                            'label' => esc_html__('Hours - Border color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(2) .time-item-inner' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(2) .time-item-inner .inner-text' => 'border-top-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'background_color_hours',
                            'label' => esc_html__('Hours - Background Number', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(2) .time-item-inner .hour' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        // Hours color setting
                        array(
                            'name' => 'background_color_item3',
                            'label' => esc_html__('Minute - Border color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(3) .time-item-inner' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(3) .time-item-inner .inner-text' => 'border-top-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'background_color_minute',
                            'label' => esc_html__('Minute - Background Number', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(3) .time-item-inner .minute' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),

                        // Second color setting
                        array(
                            'name' => 'background_color_item4',
                            'label' => esc_html__('Second - Border color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(4) .time-item-inner' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(4) .time-item-inner .inner-text' => 'border-top-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'background_color_second',
                            'label' => esc_html__('Second - Background color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .time-item:nth-child(4) .time-item-inner .second' => 'background-color: {{VALUE}};',
                            ],
                            'condition' => [
                                'layout' => array('2'),
                            ],
                        ),
                        array(
                            'name' => 'number_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .cms-count-down .inner-number',
                        ),
                    ),
                ),

                array(
                    'name' => 'section_style_text',
                    'label' => esc_html__('Countdown Text', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'text_background',
                            'label' => esc_html__('Text Background', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .inner-text' => 'background-color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'text_color',
                            'label' => esc_html__('Text Color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .cms-count-down .inner-text' => 'color: {{VALUE}};',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_style_animation',
                    'label' => esc_html__('Animation Style', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'cms_animate',
                            'label' => esc_html__('Theme Animate', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => nuvo_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'cms_animate_delay',
                            'label' => esc_html__('Animate Delay', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);