<?php

// Register Contact Form 7 Widget
if(class_exists('WPCF7')) {
    $cf7 = get_posts('post_type="wpcf7_contact_form"&numberposts=-1');

    $contact_forms = array();
    if ($cf7) {
        foreach ($cf7 as $cform) {
            $contact_forms[$cform->ID] = $cform->post_title;
        }
    } else {
        $contact_forms[esc_html__('No contact forms found', 'nuvo')] = 0;
    }

    etc_add_custom_widget(
        array(
            'name' => 'cms_ctf7',
            'title' => esc_html__('Contact Form 7', 'nuvo'),
            'icon' => 'eicon-form-horizontal',
            'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
            'scripts' => array(),
            'params' => array(
                'sections' => array(
                    array(
                        'name' => 'layout_section',
                        'label' => esc_html__('Layout', 'nuvo' ),
                        'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                        'controls' => array(
                            array(
                                'name' => 'layout',
                                'label' => esc_html__('Templates', 'nuvo' ),
                                'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
                                'default' => '1',
                                'options' => [
                                    '1' => [
                                        'label' => esc_html__('Layout 1', 'nuvo' ),
                                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_ctf7/layout-image/layout1.jpg'
                                    ],
                                ],
                            ),
                        ),
                    ),
                    array(
                        'name' => 'source_section',
                        'label' => esc_html__('Source Settings', 'nuvo'),
                        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                        'controls' => array(
                            array(
                                'name' => 'ctf7_id',
                                'label' => esc_html__('Select Form', 'nuvo'),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => $contact_forms,
                            ),
                            array(
                                'name' => 'button_style',
                                'label' => esc_html__('Button Style', 'nuvo' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => [
                                    'button-style1' => 'Inline Block',
                                    'button-style2' => 'Block',
                                ],
                                'default' => 'button-style1',
                            ),
                            array(
                                'name' => 'cms_animate',
                                'label' => esc_html__('Theme Animate', 'nuvo' ),
                                'type' => \Elementor\Controls_Manager::SELECT,
                                'options' => nuvo_animate(),
                                'default' => '',
                            ),
                        ),
                    ),
                ),
            ),
        ),
        get_template_directory() . '/elementor/core/widgets/'
    );
}