<?php
// Post term options
$post_term_options = etc_get_grid_term_options('gallery');

// Register Post Grid Widget
etc_add_custom_widget(
    array(
        'name' => 'cms_gallery_grid',
        'title' => esc_html__('Gallery Grid', 'nuvo' ),
        'icon' => 'eicon-posts-justified',
        'categories' => array( Elementor_Theme_Core::ETC_CATEGORY_NAME ),
        'scripts' => [
            'imagesloaded',
            'isotope',
            'cms-post-grid-widget-js',
        ],
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'nuvo' ),
                            'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_gallery_grid/layout-image/layout1.jpg'
                                ],
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'source_section',
                    'label' => esc_html__('Source', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'source',
                            'label' => esc_html__('Select Categories', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT2,
                            'multiple' => true,
                            'options' => $post_term_options,
                        ),
                        array(
                            'name' => 'orderby',
                            'label' => esc_html__('Order By', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'date',
                            'options' => [
                                'date' => esc_html__('Date', 'nuvo' ),
                                'ID' => esc_html__('ID', 'nuvo' ),
                                'author' => esc_html__('Author', 'nuvo' ),
                                'title' => esc_html__('Title', 'nuvo' ),
                                'rand' => esc_html__('Random', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'order',
                            'label' => esc_html__('Sort Order', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'desc',
                            'options' => [
                                'desc' => esc_html__('Descending', 'nuvo' ),
                                'asc' => esc_html__('Ascending', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'limit',
                            'label' => esc_html__('Total items', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'default' => '6',
                        ),
                    ),
                ),
                array(
                    'name' => 'grid_section',
                    'label' => esc_html__('Grid', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'thumbnail',
                            'type' => \Elementor\Group_Control_Image_Size::get_type(),
                            'control_type' => 'group',
                            'default' => 'full',
                        ),
                        array(
                            'name' => 'filter',
                            'label' => esc_html__('Filter on Masonry', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'true' => esc_html__('Enable', 'nuvo' ),
                                'false' => esc_html__('Disable', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'filter_default_title',
                            'label' => esc_html__('Filter Default Title', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => esc_html__('All', 'nuvo' ),
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),
                        array(
                            'name' => 'filter_alignment',
                            'label' => esc_html__('Filter Alignment', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'center',
                            'options' => [
                                'center' => esc_html__('Center', 'nuvo' ),
                                'left' => esc_html__('Left', 'nuvo' ),
                                'right' => esc_html__('Right', 'nuvo' ),
                            ],
                            'condition' => [
                                'filter' => 'true',
                            ],
                        ),

                        array(
                            'name' => 'show_filter',
                            'label' => esc_html__('Show Filter Title', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),

                        array(
                            'name' => 'pagination_type',
                            'label' => esc_html__('Pagination Type', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'false',
                            'options' => [
                                'pagination' => esc_html__('Pagination', 'nuvo' ),
                                'loadmore' => esc_html__('Loadmore', 'nuvo' ),
                                'false' => esc_html__('Disable', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'loadmore_style',
                            'label' => esc_html__('Loadmore Style', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => 'btn-default',
                            'options' => [
                                'btn-default' => esc_html__('Default( Primary )', 'nuvo' ),
                                'btn-outline' => esc_html__('Primary Outline', 'nuvo' ),
                                'btn-primary-noborder' => esc_html__('Primary No Border', 'nuvo' ),
                                'btn-white' => esc_html__('White', 'nuvo' ),
                                'btn-outline-white' => esc_html__('White Outline', 'nuvo' ),
                                'btn-outline-white' => esc_html__('White Outline', 'nuvo' ),
                                'btn-white-noborder' => esc_html__('White No Border', 'nuvo' ),
                                'btn-secondary' => esc_html__('Secondary', 'nuvo' ),
                                'btn-outline-secondary style-1' => esc_html__('Secondary Outline 1', 'nuvo' ),
                                'btn-outline-secondary style-2' => esc_html__('Secondary Outline 2', 'nuvo' ),
                                'btn-secondary-noborder' => esc_html__('Secondary No Border 1', 'nuvo' ),
                                'btn-secondary-noborder style2' => esc_html__('Secondary No Border 2', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'gap',
                            'label' => esc_html__('Item Gap', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::NUMBER,
                            'control_type' => 'responsive',
                            'default' => 15,
                            'selectors' => [
                                '{{WRAPPER}} .cms-grid .grid-item' => 'padding-left: {{VALUE}}px; padding-right: {{VALUE}}px;',
                            ],
                        ),
                        array(
                            'name' => 'col_xs',
                            'label' => esc_html__('Columns XS Devices', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '1',
                            'options' => [
                                '1' => esc_html__('1', 'nuvo' ),
                                '2' => esc_html__('2', 'nuvo' ),
                                '3' => esc_html__('3', 'nuvo' ),
                                '4' => esc_html__('4', 'nuvo' ),
                                '6' => esc_html__('6', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'col_sm',
                            'label' => esc_html__('Columns SM Devices', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '2',
                            'options' => [
                                '1' => esc_html__('1', 'nuvo' ),
                                '2' => esc_html__('2', 'nuvo' ),
                                '3' => esc_html__('3', 'nuvo' ),
                                '4' => esc_html__('4', 'nuvo' ),
                                '6' => esc_html__('6', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'col_md',
                            'label' => esc_html__('Columns MD Devices', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '3',
                            'options' => [
                                '1' => esc_html__('1', 'nuvo' ),
                                '2' => esc_html__('2', 'nuvo' ),
                                '3' => esc_html__('3', 'nuvo' ),
                                '4' => esc_html__('4', 'nuvo' ),
                                '6' => esc_html__('6', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'col_lg',
                            'label' => esc_html__('Columns LG Devices', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => esc_html__('1', 'nuvo' ),
                                '2' => esc_html__('2', 'nuvo' ),
                                '3' => esc_html__('3', 'nuvo' ),
                                '4' => esc_html__('4', 'nuvo' ),
                                '6' => esc_html__('6', 'nuvo' ),
                            ],
                        ),
                        array(
                            'name' => 'col_xl',
                            'label' => esc_html__('Columns XL Devices', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'default' => '4',
                            'options' => [
                                '1' => esc_html__('1', 'nuvo' ),
                                '2' => esc_html__('2', 'nuvo' ),
                                '3' => esc_html__('3', 'nuvo' ),
                                '4' => esc_html__('4', 'nuvo' ),
                                '6' => esc_html__('6', 'nuvo' ),
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'display_section',
                    'label' => esc_html__('Display Options', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'hover_style',
                            'label' => esc_html__('Hover Style', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => [
                                'hv-style1' => esc_html__('Hover Style1', 'nuvo' ),
                                'hv-style2' => esc_html__('Hover Style2', 'nuvo' ),
                            ],
                            'default' => 'hv-style2',
                        ),

                        array(
                            'name' => 'show_thumbnail',
                            'label' => esc_html__('Show Thumbnail', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                            'separator' => 'after',
                        ),
                        array(
                            'name' => 'show_title',
                            'label' => esc_html__('Show Title', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SWITCHER,
                            'default' => 'true',
                        ),
                        array(
                            'name' => 'cms_animate',
                            'label' => esc_html__('Theme Animate', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => nuvo_animate(),
                            'default' => '',
                        ),
                    ),
                ),
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);