<?php
$default_settings = [
    'cms_animate' => '',
    'title_text' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$widget->add_render_attribute( 'description_text', 'class', 'custom-description' );
$widget->add_inline_editing_attributes( 'description_text' );

$time_to = $settings['time_to'];
?>
<div class="cms-count-down layout2 <?php echo esc_attr($cms_animate); ?>">
    <div class="item-box-title">
        <?php if(!empty($settings['title_text'])) : ?>
            <h3 class="item--title">
                <?php echo wp_kses_post($settings['title_text']); ?>
            </h3>
        <?php endif; ?>
        <?php if(!empty($settings['description_text'])) : ?>
            <div <?php etc_print_html($widget->get_render_attribute_string( 'description_text' )); ?>>
                <i class="icon-left fa fa-angle-double-left"></i>
                    <marquee direction="" onmouseover="this.stop();" onmouseout="this.start();">
                        <?php echo wp_kses_post($settings['description_text']); ?>
                    </marquee>
                <i class="icon-right fa fa-angle-double-left"></i>
            </div>
        <?php endif; ?>
    </div>
    <div class="cms-count-down-container font-smooth" data-time="<?php echo esc_attr($time_to); ?>">
        <div class="time-item">
            <div class="time-item-inner">
                <div class="day inner-number"></div>
                <div class="inner-text"><?php echo esc_html__('Days', 'nuvo') ?></div>
            </div>
        </div>
        <div class="time-item">
            <div class="time-item-inner">
                <div class="hour inner-number"></div>
                <div class="inner-text"><?php echo esc_html__('Hours', 'nuvo') ?></div>
            </div>
        </div>
        <div class="time-item">
            <div class="time-item-inner">
                <div class="minute inner-number"></div>
                <div class="inner-text"><?php echo esc_html__('Minutes', 'nuvo') ?></div>
            </div>
        </div>
        <div class="time-item">
            <div class="time-item-inner">
                <div class="second inner-number"></div>
                <div class="inner-text"><?php echo esc_html__('Seconds', 'nuvo') ?></div>
            </div>
        </div>
    </div>
    <?php if(!empty($time_to)) : ?>
        <div class="item-date-feature">                
            <div class="item-date-inner">
                <span class="bullet bullet-left"></span>
                <?php echo esc_html( date('F d, Y', strtotime($time_to)) ); ?>
                <?php echo esc_html__( 'at','nuvo' ); ?>
                <?php echo esc_html( date('H:i A', strtotime($time_to)) ); ?>
                <span class="bullet bullet-right"></span>
            </div>
        </div>
    <?php endif; ?>
</div>
