<?php
$default_settings = [
    'col_xl' => '4',
    'col_lg' => '4',
    'col_md' => '3',
    'col_sm' => '2',
    'col_xs' => '1',

    'menu_list' => '',
    'thumbnail_size' => '',
    'thumbnail_custom_dimension' => '',
    'cms_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$col_xl = 12 / intval($col_xl);
$col_lg = 12 / intval($col_lg);
$col_md = 12 / intval($col_md);
$col_sm = 12 / intval($col_sm);
$col_xs = 12 / intval($col_xs);
$grid_sizer = "col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";
$item_class = "grid-item col-xl-{$col_xl} col-lg-{$col_lg} col-md-{$col_md} col-sm-{$col_sm} col-{$col_xs}";

if($thumbnail_size != 'custom'){
    $img_size = $thumbnail_size;
}
elseif(!empty($thumbnail_custom_dimension['width']) && !empty($thumbnail_custom_dimension['height'])){
    $img_size = $thumbnail_custom_dimension['width'] . 'x' . $thumbnail_custom_dimension['height'];
}
else{
    $img_size = 'full';
}

?>

<div class="cms-grid cms-menu-grid1">
    <?php if(isset($menu_list) && !empty($menu_list) && count($menu_list)): ?>
        <div class="cms-grid-inner cms-grid-masonry row" data-gutter="7">
            <?php foreach ($menu_list as $key => $value):
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $value['link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                    if ( $value['link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );

                $title = isset($value['title']) ? $value['title'] : '';
                $description = isset($value['description']) ? $value['description'] : '';
                $feature_text = isset($value['feature_text']) ? $value['feature_text'] : '';
                $btn1 = isset($value['btn1']) ? $value['btn1'] : '';
                $btn1_text = isset($value['btn1_text']) ? $value['btn1_text'] : '';
                
                $btn2 = isset($value['btn2']) ? $value['btn2'] : '';
                $btn2_text = isset($value['btn2_text']) ? $value['btn2_text'] : '';

                $image = isset($value['image']) ? $value['image'] : '';
    			$img = etc_get_image_by_size( array(
                    'attach_id'  => $image['id'],
                    'thumb_size' => $img_size,
                    'class'      => '',
                ));
                $thumbnail = $img['thumbnail'];

            	?>
                <div class="<?php echo esc_attr($item_class); ?>">
                    <div class="menu-item <?php echo esc_attr( $cms_animate ); ?>">
                        <?php if(!empty($image)) { ?>
                            <div class="item-image">
                                <div class="inner-item-image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                    <?php if(!empty($price)) { ?>
                                        <span class="item-price"><?php echo esc_attr($price); ?></span>
                                    <?php } ?>
                                    <a class="light-box" href="<?php echo wp_get_attachment_image_url( $image['id'], $size = 'full') ?>"><i class="fa fa-search"></i></a>
                                    <?php if(!empty($feature_text)) { ?>
                                        <div class="feature-popular">
                                            <span><?php echo esc_attr($feature_text); ?></span>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="item-meta">
                           <?php if(!empty($title)) { ?>
                                <h3 class="item-name">
                                    <?php if (!empty($link_attributes)){ ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                        <?php echo esc_attr($title); ?>
                                    <?php if (!empty($link_attributes)){ ?></a><?php } ?>
                                </h3>
                            <?php } ?>
                            <?php if(!empty( $description )) { ?>
                                <div class="item-description"><?php echo wp_kses_post( $description ); ?></div>
                            <?php } ?>
                            <div class="feature-excerpt">
                                <?php if(!empty($btn1) || !empty($btn1_text)) { ?>
                                    <div class="button-tooltip btn-1">
                                        <?php echo esc_attr( $btn1 ); ?>
                                        <?php if(!empty($btn1_text)) { ?>
                                            <div class="content-tooltip"><?php echo esc_attr( $btn1_text ); ?></div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <?php if(!empty($btn2) || !empty($btn2_text)) { ?>
                                    <div class="button-tooltip btn-2">
                                        <?php echo esc_attr( $btn2 ); ?>
                                        <?php if(!empty($btn2_text)) { ?>
                                            <div class="content-tooltip"><?php echo esc_attr( $btn2_text ); ?></div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <div class="grid-sizer <?php echo esc_attr($grid_sizer); ?>"></div>
        </div>
    <?php endif; ?>
</div>
