<?php
$default_settings = [
    'phone' => '',
    'phone_link' => '',
    'cms_animate' => '',
    
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$html_id = etc_get_element_id($settings);
/* Button Link */
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
$link_attributes = $widget->get_render_attribute_string( 'link' );

?>
<div class="cms-phone-ring <?php echo esc_attr($cms_animate); ?>">
	<?php if(!empty($settings['phone'])) : ?>
		<div class="box-phone">
			<div class="phonering-alo-phone phonering-alo-green phonering-alo-show" id="phonering-alo-phoneIcon">
				<div class="phonering-alo-ph-circle"></div>
				 <div class="phonering-alo-ph-circle-fill"></div>
				<a href="tel:<?php echo esc_attr( $phone_link ); ?>" class="pps-btn-img">
				 	<span class="phonering-alo-ph-img-circle">
				 		<i class="fa fa-phone"></i>
				 	</span>
				 </a>
			</div>
			<div class="text-number">
				<a href="tel:<?php echo esc_attr( $phone_link ); ?>">
					<?php echo esc_attr($settings['phone']); ?>	
				</a>
			</div>
		</div>
	<?php endif; ?>
	<?php if(!empty($settings['button_text'])) : ?>
		<div class="wp-buttom">
		    <a class="btn btn-primary-ol" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
		        <?php echo esc_attr($settings['button_text']); ?>
		    </a>
		</div>
    <?php endif; ?>
</div>
