<?php
if ( ! class_exists( 'ReduxFrameworkInstances' ) ) {
	return;
}

class CSS_Generator {
	/**
     * scssc class instance
     *
     * @access protected
     * @var scssc
     */
    protected $scssc = null;

    /**
     * ReduxFramework class instance
     *
     * @access protected
     * @var ReduxFramework
     */
    protected $redux = null;

    /**
     * Debug mode is turn on or not
     *
     * @access protected
     * @var boolean
     */
    protected $dev_mode = true;

    /**
     * opt_name of ReduxFramework
     *
     * @access protected
     * @var string
     */
    protected $opt_name = '';

	/**
	 * Constructor
	 */
	function __construct() {
		$this->opt_name = nuvo_get_opt_name();

		if ( empty( $this->opt_name ) ) {
			return;
		}
		$this->dev_mode = nuvo_get_opt( 'dev_mode', '0' ) === '1' ? true : false;
		add_filter( 'cms_scssc_on', '__return_true' );
		add_action( 'init', array( $this, 'init' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue' ), 20 );
	}

	/**
	 * init hook - 10
	 */
	function init() {
		if ( ! class_exists( 'scssc' ) ) {
			return;
		}

		$this->redux = ReduxFrameworkInstances::get_instance( $this->opt_name );

		if ( empty( $this->redux ) || ! $this->redux instanceof ReduxFramework ) {
			return;
		}
		add_action( 'wp', array( $this, 'generate_with_dev_mode' ) );
		add_action( "redux/options/{$this->opt_name}/saved", function () {
			$this->generate_file();
		} );
	}

	function generate_with_dev_mode() {
		if ( $this->dev_mode === true ) {
			$this->generate_file();
		}
	}

	/**
	 * Generate options and css files
	 */
	function generate_file() {
		$scss_dir = get_template_directory() . '/assets/scss/';
		$css_dir  = get_template_directory() . '/assets/css/';

		$this->scssc = new scssc();
		$this->scssc->setImportPaths( $scss_dir );

		$_options = $scss_dir . 'variables.scss';

		$this->redux->filesystem->execute( 'put_contents', $_options, array(
			'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->options_output() )
		) );
		$css_file = $css_dir . 'theme.css';

		$this->scssc->setFormatter( 'scss_formatter' );
		$this->redux->filesystem->execute( 'put_contents', $css_file, array(
			'content' => preg_replace( "/(?<=[^\r]|^)\n/", "\r\n", $this->scssc->compile( '@import "theme.scss"' ) )
		) );
	}

	/**
	 * Output options to _variables.scss
	 *
	 * @access protected
	 * @return string
	 */
	protected function options_output() {
		ob_start();

		$primary_color = nuvo_get_opt( 'primary_color', '#ff4c01' );
		if ( ! nuvo_is_valid_color( $primary_color ) ) {
			$primary_color = '#ff4c01';
		}
		printf( '$primary_color: %s;', esc_attr( $primary_color ) );


		$primary_color2 = nuvo_get_opt( 'primary_color2', '#a37b44' );
		if ( ! nuvo_is_valid_color( $primary_color2 ) ) {
			$primary_color2 = '#a37b44';
		}
		printf( '$primary_color2: %s;', esc_attr( $primary_color2 ) );

		$secondary_color = nuvo_get_opt( 'secondary_color', '#0b2653' );
		if ( ! nuvo_is_valid_color( $secondary_color ) ) {
			$secondary_color = '#0b2653';
		}
		printf( '$secondary_color: %s;', esc_attr( $secondary_color ) );

		/*Regular Color*/
		$regular_color = nuvo_get_opt( 'regular_color', '#888' );
		if ( ! nuvo_is_valid_color( $regular_color ) ) {
			$regular_color = '#888';
		}
		printf( '$regular_color: %s;', esc_attr( $regular_color ) );

		$link_color = nuvo_get_opt( 'link_color', '#ff4c01' );
		if ( ! empty( $link_color['regular'] ) && isset( $link_color['regular'] ) ) {
			printf( '$link_color: %s;', esc_attr( $link_color['regular'] ) );
		} else {
			echo '$link_color: #ff4c01;';
		}

		$link_color_hover = nuvo_get_opt( 'link_color', '#ff4c01' );
		if ( ! empty( $link_color['hover'] ) && isset( $link_color['hover'] ) ) {
			printf( '$link_color_hover: %s;', esc_attr( $link_color['hover'] ) );
		} else {
			echo '$link_color_hover: #ff4c01;';
		}

		$link_color_active = nuvo_get_opt( 'link_color', '#ff4c01' );
		if ( ! empty( $link_color['active'] ) && isset( $link_color['active'] ) ) {
			printf( '$link_color_active: %s;', esc_attr( $link_color['active'] ) );
		} else {
			echo '$link_color_active: #ff4c01;';
		}

		/* Font */
		$body_default_font = nuvo_get_opt( 'body_default_font', 'Open Sans' );
		if ( isset( $body_default_font ) ) {
			echo '
                $body_default_font: ' . esc_attr( $body_default_font ) . ';
            ';
		}

		$heading_default_font = nuvo_get_opt( 'heading_default_font', 'Open Sans' );
		if ( isset( $heading_default_font ) ) {
			echo '
                $heading_default_font: ' . esc_attr( $heading_default_font ) . ';
            ';
		}

		return ob_get_clean();
	}

	/**
	 * Hooked wp_enqueue_scripts - 20
	 * Make sure that the handle is enqueued from earlier wp_enqueue_scripts hook.
	 */
	function enqueue() {
		$css = $this->inline_css();
		if ( ! empty( $css ) ) {
			wp_add_inline_style( 'nuvo-theme', $this->dev_mode ? $css : nuvo_css_minifier( $css ) );
		}
	}


	/**
	 * Generate inline css based on theme options
	 */
	protected function inline_css() {
		ob_start();
		/* Logo */
        $logo_maxh = nuvo_get_opt( 'logo_maxh' );
        $max_height = '';
        if ( (isset($logo_maxh['height']) && !empty( $logo_maxh['height'])) && $logo_maxh['height'] != 'px') {
            $max_height = $logo_maxh['height'];
        }
        
        $p_logo_maxh = nuvo_get_page_opt( 'logo_maxh' );
        if ( (isset($p_logo_maxh['height']) && !empty( $p_logo_maxh['height'])) && $p_logo_maxh['height'] != 'px'){
            $max_height = $p_logo_maxh['height'];
        }
        
        if(!empty($max_height)){
            printf( '#site-header-wrap .site-branding a img { max-height: %s; }', esc_attr($max_height) );
        }

		?>

		<?php 
		$logo_maxh_sm = nuvo_get_opt( 'logo_maxh_sm' );
		if ( ! empty( $logo_maxh_sm['height'] ) && $logo_maxh_sm['height'] != 'px' ) {
			printf( '@media screen and (max-width: 1199px) { #site-header-wrap .site-branding a img { max-height: %s; } }', esc_attr( $logo_maxh_sm['height'] ) );
		} 
		?>
		<?php /* Menu */
		$menu_text_transform = nuvo_get_opt( 'menu_text_transform' );
		if ( ! empty( $menu_text_transform ) ) {
			printf( '.primary-menu > li > a { text-transform: %s !important; }', esc_attr( $menu_text_transform ) );
		}
		$menu_font_size = nuvo_get_opt( 'menu_font_size' );
		if ( ! empty( $menu_font_size ) ) {
			printf( '.primary-menu > li > a { font-size: %s' . 'px !important; }', esc_attr( $menu_font_size ) );
		}
		$main_menu_color = nuvo_get_opt( 'main_menu_color' );
		if ( ! empty( $main_menu_color['regular'] ) ) {
			printf( '.primary-menu > li > a { color: %s !important; }', esc_attr( $main_menu_color['regular'] ) );
		}
		if ( ! empty( $main_menu_color['hover'] ) ) {
			printf( '.primary-menu > li > a:hover { color: %s !important; }', esc_attr( $main_menu_color['hover'] ) );
		}
		if ( ! empty( $main_menu_color['active'] ) ) {
			printf( '.primary-menu > li.current_page_item > a, .primary-menu > li.current-menu-item > a, .primary-menu > li.current_page_ancestor > a, .primary-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr( $main_menu_color['active'] ) );
		}
		$sticky_menu_color = nuvo_get_opt( 'sticky_menu_color' );
		if ( ! empty( $sticky_menu_color['regular'] ) ) {
			printf( '#site-header.h-fixed .primary-menu > li > a { color: %s !important; }', esc_attr( $sticky_menu_color['regular'] ) );
		}
		if ( ! empty( $sticky_menu_color['hover'] ) ) {
			printf( '#site-header.h-fixed .primary-menu > li > a:hover { color: %s !important; }', esc_attr( $sticky_menu_color['hover'] ) );
		}
		if ( ! empty( $sticky_menu_color['active'] ) ) {
			printf( '#site-header.h-fixed .primary-menu > li.current_page_item > a, #site-header.h-fixed .primary-menu > li.current-menu-item > a, #site-header.h-fixed .primary-menu > li.current_page_ancestor > a, #site-header.h-fixed .primary-menu > li.current-menu-ancestor > a { color: %s !important; }', esc_attr( $sticky_menu_color['active'] ) );
		}

		/* Page Title */

		$shop_page_title_img = nuvo_get_opt( 'shop_page_title_img' );
		if ( ! empty( $shop_page_title_img['url'] ) ) {
			echo '.post-type-archive-product #pagetitle.page-title {
                background-image: url(' . esc_attr( $shop_page_title_img['url'] ) . ') !important;
            }';
		}

		$custom_pagetitle = nuvo_get_page_opt( 'custom_pagetitle' );
		$ptitle_bg = nuvo_get_page_opt( 'page_title_bg' );
		if ( $custom_pagetitle == 'show' && ! empty( $ptitle_bg['url'] ) ) {
			echo 'body #pagetitle.page-title {
                background-image: url(' . esc_attr( $ptitle_bg['url'] ) . ') !important;
            }';
		}
		
		if ( ! empty( $ptitle_bg['background-image'] ) ) {
			echo 'body #pagetitle.page-title {
	            background-image: url(' . esc_attr( $ptitle_bg['background-image'] ) . ');
	        }';
		}

	    $title_font_size = nuvo_get_opt( 'title_font_size' );
	    $page_title_font_size = nuvo_get_page_opt( 'title_font_size' );
	    if($custom_pagetitle && !empty($page_title_font_size)) {
	        $title_font_size = $page_title_font_size;
	    }
	    if ( !empty( $title_font_size ) ) {
	        printf( '#pagetitle h1.entry-page-title { font-size: %s'.'px; }', esc_attr($title_font_size) );
	    }


	    $title_line_hegiht = nuvo_get_opt( 'title_line_hegiht' );
	    $page_title_line_hegiht = nuvo_get_page_opt( 'title_line_hegiht' );
	    if($custom_pagetitle && !empty($page_title_line_hegiht)) {
	        $title_line_hegiht = $page_title_line_hegiht;
	    }
	    if ( !empty( $title_line_hegiht ) ) {
	        printf( '#pagetitle h1.entry-page-title { line-height: %s'.'px; }', esc_attr($title_line_hegiht) );
	    }

		/* Content */
		$content_bg_color = nuvo_get_page_opt( 'content_bg_color' );
		if ( ! empty( $content_bg_color['color'] ) ) {
			echo '#pagetitle svg path {
                fill: ' . esc_attr( $content_bg_color['color'] ) . ';
            }';
		}

		/* Custom Css */
		$custom_css = nuvo_get_opt( 'site_css' );
		if ( ! empty( $custom_css ) ) {
			echo esc_attr( $custom_css );
		}

        $primary_color = nuvo_get_page_opt( 'primary_color' );
        if ( ! empty( $primary_color ) )
        {
            printf( '.primary-menu > li > a:before
                { border-color: transparent transparent %s!important; }', esc_attr($primary_color) 
            );
			/*Border Color*/
			printf( '
				.cms-event-carousel-layout1 .slick-arrow:hover,
				.primary-menu .sub-menu, .primary-menu .children,
				.cms-post-carousel-layout4 .cms-light-box .btn-meta a,
				.cms-post-carousel-layout5 .cms-light-box .btn-meta a
                { border-color: %s!important; }', esc_attr($primary_color) 
            );

			/*Color*/
            printf( '
            	.ctf-tweets .ctf-tweet-meta a,
            	.cms-twitter-custom .ctf-tweets .ctf-item .ctf-tweet-content a,
            	.cms-twitter-custom .ctf-tweets .ctf-item .ctf-corner-logo:before,
            	.elementor-text-editor a,
				.cms-count-down .item--title,
				.cms-count-down .inner-text,
            	.primary-menu > li:hover > a, .primary-menu > li.current_page_item > a, .primary-menu > li.current-menu-item > a, .primary-menu > li.current_page_ancestor > a, .primary-menu > li.current-menu-ancestor > a,
				
				.primary-menu .sub-menu li > a:hover, .primary-menu .children li > a:hover, .primary-menu .sub-menu li.current_page_item > a, .primary-menu .children li.current_page_item > a, .primary-menu .sub-menu li.current-menu-item > a, .primary-menu .children li.current-menu-item > a, .primary-menu .sub-menu li.current_page_ancestor > a, .primary-menu .children li.current_page_ancestor > a, .primary-menu .sub-menu li.current-menu-ancestor > a, .primary-menu .children li.current-menu-ancestor > a,

				.rev_slider .tp-leftarrow.custom:before,
				.cms-post-carousel-layout4 .cms-light-box .btn-meta a,
				.cms-post-carousel-layout5 .cms-light-box .btn-meta a,
				.cms-post-carousel-layout4 .entry-title a:hover,
				.cms-post-carousel-layout5 .entry-title a:hover,
				.cms-pointofsale-carousel .entry-title a,
				#site-header-wrap .site-header-search span:hover,
				.revslider-initialised .tparrows.arrow-nustic:before,
				.text-p-custom strong,
				.cms-navigation-menu1 ul.menu li a:hover,
				.cms-navigation-menu1 ul.menu li.current_page_item > a,
				.primary-menu .sub-menu li a:before, .primary-menu .children li a:before,
				.cms-event-carousel-layout1 .slick-arrow:hover:after,
				.cms-post-carousel-layout4 .slick-arrow:hover:after
                { color: %s!important; }', esc_attr($primary_color) 
            );
            /*Box shadow*/
            printf( '
            	.btn.btn-default,
            	.cms-post-carousel-layout4 .btn-more,
            	.cms-contact-form .wpcf7-form .wpcf7-form-control.wpcf7-submit,
				.cms-event-carousel-layout1 .entry-button .btn-more,
            	.cms-post-carousel-layout5 .btn-more
                { box-shadow: 0 3px %s!important; }', esc_attr($primary_color) 
            );
            /*Background*/
            printf( '
            	#ui-datepicker-div .ui-datepicker-header,
            	#ui-datepicker-div .ui-datepicker-calendar th,
            	#ui-datepicker-div .ui-datepicker-calendar td a:hover,
            	.main-menu-toggle,
                .scroll-top,
				.primary-menu > li > a:after,
				.cms-post-carousel-layout4 .cms-light-box .btn-meta a:hover,
				.cms-post-carousel-layout5 .cms-light-box .btn-meta a:hover,
				.cms-post-carousel-layout5 .item--icon,
				.cms-post-carousel-layout5 .btn-more,
				.cms-post-carousel-layout4 .btn-more,
				.cms-event-carousel-layout1 .entry-button .btn-more,
				.cms-event-carousel-layout1 .item-date,
				.cms-contact-form .wpcf7-form .wpcf7-form-control.wpcf7-submit,
				.cms-pointofsale-carousel .entry-featured .item--icon,
				.cms-pointofsale-carousel .entry-body .item--icon:before,
				.cms-post-carousel-layout4 .item-date,
				body.site-boxed #site-header-wrap .site-header-top,
				.btn.btn-default,
				.cms-modal-search .cms-modal-close
                { background-color: %s!important; }', esc_attr($primary_color) 
            );
        }

        $primary_color2 = nuvo_get_page_opt( 'primary_color2' );
        if ( ! empty( $primary_color2 ) )
        {
            printf( '
            	.ctf-tweets .ctf-tweet-meta a:hover,
            	.cms-twitter-custom .ctf-tweets .ctf-item .ctf-tweet-content a:hover,
            	.cms-twitter-custom .ctf-tweets .ctf-item:hover .ctf-corner-logo:before
                { color: %s!important; }', esc_attr($primary_color2) 
            );
            /*Box shadow*/
            printf( '
            	.btn.btn-default,
            	.cms-post-carousel-layout4 .btn-more,
            	.cms-contact-form .wpcf7-form .wpcf7-form-control.wpcf7-submit,
				.cms-event-carousel-layout1 .entry-button .btn-more,
            	.cms-post-carousel-layout5 .btn-more
                { box-shadow: 0 3px %s!important; }', esc_attr($primary_color2) 
            );
            /*Background*/
            printf( '
            	.btn.btn-default:hover,
            	.cms-post-carousel-layout4 .btn-more:hover,
            	.cms-contact-form .wpcf7-form .wpcf7-form-control.wpcf7-submit:hover,
				.cms-event-carousel-layout1 .entry-button .btn-more:hover,
            	.cms-post-carousel-layout5 .btn-more:hover
                { background-color: %s!important; }', esc_attr($primary_color2) 
            );
        }

		return ob_get_clean();
	}
}

new CSS_Generator();