<?php
/**
 * Register metabox for posts based on Redux Framework. Supported methods:
 *     isset_args( $post_type )
 *     set_args( $post_type, $redux_args, $metabox_args )
 *     add_section( $post_type, $sections )
 * Each post type can contains only one metabox. Pease note that each field id
 * leads by an underscore sign ( _ ) in order to not show that into Custom Field
 * Metabox from WordPress core feature.
 *
 * @param  CMS_Post_Metabox $metabox
 */

add_action( 'cms_post_metabox_register', 'nuvo_page_options_register' );

/**
 * get list menu.
 * @return array
 */
function nuvo_get_nav_menu(){

    $menus = array(
        '' => esc_html__('Default', 'nuvo')
    );

    $obj_menus = wp_get_nav_menus();

    foreach ($obj_menus as $obj_menu){
        $menus[$obj_menu->term_id] = $obj_menu->name;
    }
    return $menus;
}

function nuvo_page_options_register( $metabox ) {

	if ( ! $metabox->isset_args( 'post' ) ) {
		$metabox->set_args( 'post', array(
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Settings', 'nuvo' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'product' ) ) {
		$metabox->set_args( 'product', array(
			'opt_name'            => 'product_option',
			'display_name'        => esc_html__( 'Product Settings', 'nuvo' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'page' ) ) {
		$metabox->set_args( 'page', array(
			'opt_name'            => nuvo_get_page_opt_name(),
			'display_name'        => esc_html__( 'Page Settings', 'nuvo' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_audio' ) ) {
		$metabox->set_args( 'cms_pf_audio', array(
			'opt_name'     => 'post_format_audio',
			'display_name' => esc_html__( 'Audio', 'nuvo' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_link' ) ) {
		$metabox->set_args( 'cms_pf_link', array(
			'opt_name'     => 'post_format_link',
			'display_name' => esc_html__( 'Link', 'nuvo' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_quote' ) ) {
		$metabox->set_args( 'cms_pf_quote', array(
			'opt_name'     => 'post_format_quote',
			'display_name' => esc_html__( 'Quote', 'nuvo' )
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_video' ) ) {
		$metabox->set_args( 'cms_pf_video', array(
			'opt_name'     => 'post_format_video',
			'display_name' => esc_html__( 'Video', 'nuvo' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	if ( ! $metabox->isset_args( 'cms_pf_gallery' ) ) {
		$metabox->set_args( 'cms_pf_gallery', array(
			'opt_name'     => 'post_format_gallery',
			'display_name' => esc_html__( 'Gallery', 'nuvo' ),
			'class'        => 'fully-expanded',
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/* Extra Post Type */
	if ( ! $metabox->isset_args( 'pointofsale' ) ) {
		$metabox->set_args( 'pointofsale', array(
			'opt_name'            => 'pointofsale_option',
			'display_name'        => esc_html__( 'Pointofsale Settings', 'nuvo' ),
			'show_options_object' => false,
		), array(
			'context'  => 'advanced',
			'priority' => 'default'
		) );
	}

	/**
	 * Config post meta options
	 *
	 */
	$metabox->add_section( 'post', array(
		'title'  => esc_html__( 'Post Settings', 'nuvo' ),
		'icon'   => 'el el-refresh',
		'fields' => array(
			array(
	            'id'       => 'icon_type',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Icon Type', 'nuvo'),
	            'options'  => array(
	                'icon'  => esc_html__('Icon', 'nuvo'),
	                'image'  => esc_html__('Image', 'nuvo'),
	            ),
	            'default'  => 'icon'
	        ),
			array(
	            'id'       => 'class_icon',
	            'type'     => 'cms_iconpicker',
	            'title'    => esc_html__('Icon', 'nuvo'),
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'icon' ),
            	'force_output' => true
	        ),
	        array(
	            'id'       => 'class_icon_img',
	            'type'     => 'media',
	            'title'    => esc_html__('Icon Image', 'nuvo'),
	            'default' => '',
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'image' ),
            	'force_output' => true
	        ),
			array(
				'id'           => 'sub_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Sub Title', 'nuvo' ),
				'force_output' => true
			),
			array(
				'id'             => 'post_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-post #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'nuvo' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'nuvo' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'nuvo' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'show_sidebar_post',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Sidebar', 'nuvo' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_post_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'nuvo' ),
				'options'      => array(
					'left'  => esc_html__('Left', 'nuvo'),
	                'right' => esc_html__('Right', 'nuvo'),
	                'none'  => esc_html__('Disabled', 'nuvo')
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_post', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );
	
	/**
	 * Config post format meta options
	 *
	 */

	$metabox->add_section( 'cms_pf_video', array(
		'title'  => esc_html__( 'Video', 'nuvo' ),
		'fields' => array(
			array(
				'id'    => 'post-video-url',
				'type'  => 'text',
				'title' => esc_html__( 'Video URL', 'nuvo' ),
				'desc'  => esc_html__( 'YouTube or Vimeo video URL', 'nuvo' )
			),

			array(
				'id'    => 'post-video-file',
				'type'  => 'editor',
				'title' => esc_html__( 'Video Upload', 'nuvo' ),
				'desc'  => esc_html__( 'Upload video file', 'nuvo' )
			),

			array(
				'id'    => 'post-video-html',
				'type'  => 'textarea',
				'title' => esc_html__( 'Embadded video', 'nuvo' ),
				'desc'  => esc_html__( 'Use this option when the video does not come from YouTube or Vimeo', 'nuvo' )
			)
		)
	) );

	$metabox->add_section( 'cms_pf_gallery', array(
		'title'  => esc_html__( 'Gallery', 'nuvo' ),
		'fields' => array(
			array(
				'id'       => 'post-gallery-lightbox',
				'type'     => 'switch',
				'title'    => esc_html__( 'Lightbox?', 'nuvo' ),
				'subtitle' => esc_html__( 'Enable lightbox for gallery images.', 'nuvo' ),
				'default'  => true
			),
			array(
				'id'       => 'post-gallery-images',
				'type'     => 'gallery',
				'title'    => esc_html__( 'Gallery Images ', 'nuvo' ),
				'subtitle' => esc_html__( 'Upload images or add from media library.', 'nuvo' )
			)
		)
	) );

	$metabox->add_section( 'cms_pf_audio', array(
		'title'  => esc_html__( 'Audio', 'nuvo' ),
		'fields' => array(
			array(
				'id'          => 'post-audio-url',
				'type'        => 'text',
				'title'       => esc_html__( 'Audio URL', 'nuvo' ),
				'description' => esc_html__( 'Audio file URL in format: mp3, ogg, wav.', 'nuvo' ),
				'validate'    => 'url',
				'msg'         => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_link', array(
		'title'  => esc_html__( 'Link', 'nuvo' ),
		'fields' => array(
			array(
				'id'       => 'post-link-url',
				'type'     => 'text',
				'title'    => esc_html__( 'URL', 'nuvo' ),
				'validate' => 'url',
				'msg'      => 'Url error!'
			)
		)
	) );

	$metabox->add_section( 'cms_pf_quote', array(
		'title'  => esc_html__( 'Quote', 'nuvo' ),
		'fields' => array(
			array(
				'id'    => 'post-quote-cite',
				'type'  => 'textarea',
				'title' => esc_html__( 'Cite', 'nuvo' )
			)
		)
	) );
	$revslider_options = [];
	if(class_exists('RevSliderSlider')){
		$revSliderSlider = new RevSliderSlider();
		foreach ($revSliderSlider->get_sliders_short_list() as $slider) {
			$revslider_options[$slider->alias] = $slider->title;
		}
	}
	/**
	 * Config page meta options
	 *
	 */
	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Header', 'nuvo' ),
		'desc'   => esc_html__( 'Header settings for the page.', 'nuvo' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
	            'id'           => 'site_boxed',
	            'type'         => 'button_set',
	            'title'        => esc_html__( 'Site Boxed', 'nuvo' ),
	            'options'      => array(
	                'themeoption'  => esc_html__( 'Theme Option', 'nuvo' ),
	                'show'  => esc_html__( 'Show', 'nuvo' ),
	                'hide'  => esc_html__( 'Hide', 'nuvo' ),
	            ),
	            'default'      => 'themeoption',
	        ),

			array(
	            'id'           => 'site_rustic',
	            'type'         => 'button_set',
	            'title'        => esc_html__( 'Site Rustic', 'nuvo' ),
	            'options'      => array(
	                'themeoption'  => esc_html__( 'Theme Option', 'nuvo' ),
	                'show'  => esc_html__( 'Show', 'nuvo' ),
	                'hide'  => esc_html__( 'Hide', 'nuvo' ),
	            ),
	            'default'      => 'themeoption',
	        ),

            array(
                'id'          => 'primary_color',
                'type'        => 'color',
                'title'       => esc_html__('Primary Color', 'nuvo'),
                'transparent' => false,
            ),

            array(
                'id'          => 'primary_color2',
                'type'        => 'color',
                'title'       => esc_html__('Primary Color 2', 'nuvo'),
                'transparent' => false,
            ),

			array(
				'id'      => 'custom_header',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Header', 'nuvo' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'header_layout',
				'type'         => 'image_select',
				'title'        => esc_html__( 'Layout', 'nuvo' ),
				'subtitle'     => esc_html__( 'Select a layout for header.', 'nuvo' ),
				'options'      => array(
					'0' => get_template_directory_uri() . '/assets/images/header-layout/h0.jpg',
					'1' => get_template_directory_uri() . '/assets/images/header-layout/h1.jpg',
	                '2' => get_template_directory_uri() . '/assets/images/header-layout/h2.jpg',
	                '3' => get_template_directory_uri() . '/assets/images/header-layout/h3.jpg',
	                '4' => get_template_directory_uri() . '/assets/images/header-layout/h4.jpg',
				),
				'default'      => nuvo_get_option_of_theme_options( 'header_layout' ),
				'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
			),
	        array(
	            'id'       => 'search_icon',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Search Icon', 'nuvo'),
	            'options'  => array(
	                'themeoption'  => esc_html__('Theme Option', 'nuvo'),
	                'true'  => esc_html__('Show', 'nuvo'),
	                'false'  => esc_html__('Hide', 'nuvo'),
	            ),
	            'default'  => 'themeoption'
	        ),
	        array(
	            'id'       => 'cart_on',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Cart Icon', 'nuvo'),
	            'options'  => array(
	                'show'  => esc_html__('Show', 'nuvo'),
	                'hidden'  => esc_html__('Hidden', 'nuvo'),
	            ),
	            'default'  => 'show',
	        ),
			array(
	            'id'       => 'p_logo_dark',
	            'type'     => 'media',
	            'title'    => esc_html__('Custom Logo Dark', 'nuvo'),
	            'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
	        ),
	        array(
	            'id'       => 'p_logo_light',
	            'type'     => 'media',
	            'title'    => esc_html__('Custom Logo Light', 'nuvo'),
	            'required'     => array( 0 => 'custom_header', 1 => 'equals', 2 => '1' ),
				'force_output' => true
	        ),
            array(
                'id'       => 'logo_maxh',
                'type'     => 'dimensions',
                'title'    => esc_html__('Logo Max height', 'nuvo'),
                'subtitle' => esc_html__('Set maximum height for your logo, just in case the logo is too large.', 'nuvo'),
                'width'    => false,
                'unit'     => 'px'
            ),
            array(
	            'id'          => 'revslider',
	            'type'        => 'select',
	            'title'       => esc_html__('RevSlider', 'nuvo'),
	            'desc'        => esc_html__('Make sure you have at least 1 slider from revolution slider.', 'nuvo'),
	            'options'     => $revslider_options,
	            'default'     => '',
	        ),
            array(
                'id' => 'page_one_page',
                'type' => 'switch',
                'title' => esc_html__('One Page', 'nuvo'),
                'subtitle' => esc_html__('Enable one page mode for current page.', 'nuvo'),
                'default' => false,
            ),
            array(
                'id'       => 'header_menu',
                'type'     => 'select',
                'title'    => esc_html__( 'Select Menu', 'nuvo' ),
                'subtitle' => esc_html__( 'custom menu for current page', 'nuvo' ),
                'options'  => nuvo_get_nav_menu(),
                'default' => '',
                'required'     => array( 0 => 'page_one_page', 1 => 'equals', 2 => '1' ),
                'force_output' => true
            ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Page Title', 'nuvo' ),
		'icon'   => 'el el-indent-left',
		'fields' => array(
			array(
				'id'           => 'custom_pagetitle',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Page Title', 'nuvo' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'nuvo' ),
					'show'  => esc_html__( 'Custom', 'nuvo' ),
					'hide'  => esc_html__( 'Hide', 'nuvo' ),
				),
				'default'      => 'themeoption',
			),
			
			array(
	            'id'       => 'ptitle_layout',
	            'type'     => 'image_select',
	            'title'    => esc_html__('Layout', 'nuvo'),
	            'subtitle' => esc_html__('Select a layout for page title.', 'nuvo'),
	            'options'  => array(
	                '' => get_template_directory_uri() . '/assets/images/ptitle-layout/p0.jpg',
	                '1' => get_template_directory_uri() . '/assets/images/ptitle-layout/p1.jpg',
	                '2' => get_template_directory_uri() . '/assets/images/ptitle-layout/p2.jpg',
	                '3' => get_template_directory_uri() . '/assets/images/ptitle-layout/p3.jpg',
	                '4' => get_template_directory_uri() . '/assets/images/ptitle-layout/p4.jpg',
	            ),
	            'default'  => '',
	            'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),

			array(
				'id'           => 'custom_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Title', 'nuvo' ),
				'subtitle'     => esc_html__( 'Use custom title for this page. The default title will be used on document title.', 'nuvo' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
			array(
	            'id'       => 'page_title_bg',
	            'type'     => 'media',
	            'title'    => esc_html__('Page Title Image', 'nuvo'),
	            'required' => array( 0 => 'custom_pagetitle', 1 => 'equals', 2 => 'show' ),
	            'force_output' => true
	        ),
			array(
				'id'           => 'title_font_size',
				'type'         => 'text',
				'title'        => esc_html__( 'Title Font Size', 'nuvo' ),
				'subtitle'     => esc_html__('Enter number.', 'nuvo'),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
	        array(
	            'id'           => 'title_line_hegiht',
	            'type'         => 'text',
	            'title'        => esc_html__('Line Height', 'nuvo'),
	            'validate'     => 'numeric',
	            'desc'         => esc_html__('Enter number','nuvo'),
	            'msg'          => esc_html__('Please enter number','nuvo'),
	            'default'      => '',
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
	        ),
	        array(
				'id'             => 'page_title_padding',
				'type'           => 'spacing',
				'output'         => array( 'body #pagetitle.page-title' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'nuvo' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'nuvo' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				),
				'required' => array( 0 => 'custom_pagetitle', 1 => 'equals', 2 => 'show' ),
	            'force_output' => true
			),
			array(
				'id'           => 'sub_title',
				'type'         => 'textarea',
				'title'        => esc_html__( 'Sub Title', 'nuvo' ),
				'required'     => array( 0 => 'custom_pagetitle', 1 => '=', 2 => 'show' ),
				'force_output' => true
			),
			array(
	            'id'           => 'page_breadcrumb',
	            'type'         => 'button_set',
	            'title'        => esc_html__( 'Breadcrumbs', 'nuvo' ),
	            'options'      => array(
	                'themeoption'  => esc_html__( 'Theme Option', 'nuvo' ),
	                'show'  => esc_html__( 'Show', 'nuvo' ),
	                'hide'  => esc_html__( 'Hide', 'nuvo' ),
	            ),
	            'default'      => 'themeoption',
	            'required' => array( 0 => 'custom_pagetitle', 1 => 'equals', 2 => 'show' ),
	            'force_output' => true
	        ),
            array(
                'id'       => 'page_title_align',
                'type'     => 'button_set',
                'title'    => esc_html__('Text Align', 'nuvo'),
                'subtitle'     => esc_html__('Aplly for Layout 1 & 3.', 'nuvo'),
                'options' => array(
                    '' => 'Default', 
                    'left' => 'Left', 
                    'center' => 'Center',
                    'right' => 'Right',
                 ), 
            ),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Content', 'nuvo' ),
		'desc'   => esc_html__( 'Settings for content area.', 'nuvo' ),
		'icon'   => 'el-icon-pencil',
		'fields' => array(
			array(
	            'id'       => 'bg_site_content',
	            'type'     => 'media',
	            'title'    => esc_html__('Site Background Image', 'nuvo'),
	        ),
			array(
				'id'       => 'content_bg_color',
				'type'     => 'color_rgba',
				'title'    => esc_html__( 'Background Color', 'nuvo' ),
				'subtitle' => esc_html__( 'Content background color.', 'nuvo' ),
				'output'   => array( 'background-color' => 'body .site' )
			),
			array(
				'id'             => 'content_padding',
				'type'           => 'spacing',
				'output'         => array( '#content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'nuvo' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'nuvo' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
			array(
				'id'      => 'show_sidebar_page',
				'type'    => 'switch',
				'title'   => esc_html__( 'Show Sidebar', 'nuvo' ),
				'default' => false,
				'indent'  => true
			),
			array(
				'id'           => 'sidebar_page_pos',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Sidebar Position', 'nuvo' ),
				'options'      => array(
					'left'  => esc_html__( 'Left', 'nuvo' ),
					'right' => esc_html__( 'Right', 'nuvo' ),
				),
				'default'      => 'right',
				'required'     => array( 0 => 'show_sidebar_page', 1 => '=', 2 => '1' ),
				'force_output' => true
			),
		)
	) );

	$metabox->add_section( 'page', array(
		'title'  => esc_html__( 'Footer', 'nuvo' ),
		'desc'   => esc_html__( 'Settings for footer area.', 'nuvo' ),
		'icon'   => 'el el-website',
		'fields' => array(
			array(
				'id'      => 'custom_footer',
				'type'    => 'switch',
				'title'   => esc_html__( 'Custom Layout', 'nuvo' ),
				'default' => false,
				'indent'  => true
			),
	        array(
	            'id'          => 'footer_layout_custom',
	            'type'        => 'select',
	            'title'       => esc_html__('Layout', 'nuvo'),
	            'desc'        => sprintf(esc_html__('To use this Option please %sClick Here%s to add your custom footer layout first.','nuvo'),'<a href="' . esc_url( admin_url( 'edit.php?post_type=footer' ) ) . '">','</a>'),
	            'options'     => nuvo_list_post('footer'),
	            'default'     => '',
	            'required' => array( 0 => 'custom_footer', 1 => 'equals', 2 => '1' ),
	            'force_output' => true
	        ),
	    )
	) );
	
	/**
	 * Config pointofsale meta options
	 *
	 */
	$metabox->add_section( 'pointofsale', array(
		'title'  => esc_html__( 'General', 'nuvo' ),
		'icon'   => 'el-icon-website',
		'fields' => array(
			array(
	            'id'       => 'icon_type',
	            'type'     => 'button_set',
	            'title'    => esc_html__('Icon Type', 'nuvo'),
	            'options'  => array(
	                'icon'  => esc_html__('Icon', 'nuvo'),
	                'image'  => esc_html__('Image', 'nuvo'),
	            ),
	            'default'  => 'icon'
	        ),
			array(
	            'id'       => 'class_icon',
	            'type'     => 'cms_iconpicker',
	            'title'    => esc_html__('Icon', 'nuvo'),
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'icon' ),
            	'force_output' => true
	        ),
	        array(
	            'id'       => 'class_icon_img',
	            'type'     => 'media',
	            'title'    => esc_html__('Icon Image', 'nuvo'),
	            'default' => '',
	            'required' => array( 0 => 'icon_type', 1 => 'equals', 2 => 'image' ),
            	'force_output' => true
	        ),
			array(
				'id'           => 'sub_title',
				'type'         => 'text',
				'title'        => esc_html__( 'Sub Title', 'nuvo' ),
				'force_output' => true
			),
			array(
				'id'       => 'pointofsale_except',
				'type'     => 'textarea',
				'title'    => esc_html__( 'Except', 'nuvo' ),
				'validate' => 'no_html'
			),
			array(
				'id'             => 'pointofsale_content_padding',
				'type'           => 'spacing',
				'output'         => array( '.single-pointofsale #content' ),
				'right'          => false,
				'left'           => false,
				'mode'           => 'padding',
				'units'          => array( 'px' ),
				'units_extended' => 'false',
				'title'          => esc_html__( 'Content Padding', 'nuvo' ),
				'subtitle'     => esc_html__( 'Content site paddings.', 'nuvo' ),
				'desc'           => esc_html__( 'Default: Theme Option.', 'nuvo' ),
				'default'        => array(
					'padding-top'    => '',
					'padding-bottom' => '',
					'units'          => 'px',
				)
			),
		)
	) );

	$metabox->add_section( 'pointofsale', array(
		'title'  => esc_html__( 'Page Title', 'nuvo' ),
		'icon'   => 'el el-indent-left',
		'fields' => array(
			array(
				'id'           => 'custom_pagetitle',
				'type'         => 'button_set',
				'title'        => esc_html__( 'Page Title', 'nuvo' ),
				'options'      => array(
					'themeoption'  => esc_html__( 'Theme Option', 'nuvo' ),
					'show'  => esc_html__( 'Custom', 'nuvo' ),
					'hide'  => esc_html__( 'Hide', 'nuvo' ),
				),
				'default'      => 'themeoption',
			),
		)
	) );
}

function nuvo_get_option_of_theme_options( $key, $default = '' ) {
	if ( empty( $key ) ) {
		return '';
	}
	$options = get_option( nuvo_get_opt_name(), array() );
	$value   = isset( $options[ $key ] ) ? $options[ $key ] : $default;

	return $value;
}