<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Nuvo
 */
global $wpdb; 

?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="entry-body">
        <div class="entry-content clearfix">
            <?php
                the_post_thumbnail('nuvo-large');?>
                <div class="cs-blog-meta cs-itemBlog-meta">
                    <div class="cs-blog-info clearfix">
                        <div class="cs-blog-eventsDate col-xs-12 col-sm-12 col-md-12 col-lg-3">
                            <span><?php esc_html_e('DATE / TIME', 'nuvo'); ?></span>
                            <!-- .info-bar -->
                            <?php
                                $querystr = "
                                    SELECT event_name,event_start_date,event_start_time,post_content
                                    FROM {$wpdb->prefix}em_events
                                    WHERE event_status = '1'
                                    AND post_id = " . get_the_ID() . "
                                    ";
                                $pageposts = $wpdb->get_results($querystr, OBJECT);
                                if (count($pageposts) > 0) {
                                    echo '<span>' . date('m/d/Y', strtotime($pageposts[0]->event_start_date)) . '</span>
                                          <span>' . date('H:i', strtotime($pageposts[0]->event_start_time)) . '</span>';
                                }
                            ?>
                        </div>
                        <div class="cs-blog-eventsBooking col-xs-12 col-sm-12 col-md-12 col-lg-9">
                            <?php
                            if (get_option('dbem_rsvp_enabled', '1') !== '0'):
                                ?>
                                <a href="#" class="btn btn-primary-alt" data-toggle="modal"
                                   data-target="#modal-booking"
                                   title="<?php esc_html_e('BOOK THIS AMAZING EVENT NOW', 'nuvo'); ?>"><?php esc_html_e('BOOK THIS AMAZING EVENT NOW', 'nuvo'); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <!-- Modal -->
                    <div class="modal fade" id="modal-booking" tabindex="-1" role="dialog"
                         aria-labelledby="<?php esc_html_e('BOOK THIS AMAZING EVENT NOW', 'nuvo'); ?>"
                         aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">&times;</span><span
                                                class="sr-only">Close</span></button>
                                    <h4 class="modal-title"><?php esc_html_e('BOOK THIS AMAZING EVENT NOW', 'nuvo'); ?></h4>
                                </div>
                                <div class="modal-body">
                                    <?php
                                    global $EM_Event;
                                    if (!empty($EM_Event)) {
                                        echo apply_filters('em_event_output_single_booking', $EM_Event->output('#_BOOKINGFORM', 'html'));
                                    }
                                    ?>
                                </div>
                                <div class="modal-footer">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div><!-- .entry-content -->
    </div>
</article><!-- #post -->