<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package Nuvo
 */
$image_404 = nuvo_get_opt( 'img_404' );
$sub_title_404 = nuvo_get_opt( 'sub_title_404' );
$content_404_page = nuvo_get_opt( 'content_404_page' );
$btn_text_404_page = nuvo_get_opt( 'btn_text_404_page' );
get_header(); ?>

    <div id="primary" class="content-area">
        <main id="main" class="site-main">
            <div class="container">
                <div class="row">
                    <div class="col-lg-5 col-md-6 col-sm-12 col-image-404">
                        <div class="img-404 wow zoomInLeft">
                            <?php if(!empty($image_404['url'])) { ?>
                                <img class="img-404" src="<?php echo esc_url($image_404['url']);?>" alt="<?php the_title(); ?>" />
                            <?php } ?>
                        </div>
                    </div>
                    <div class="col-lg-7 col-md-6 col-sm-12 col-content">
                        <section class="error-404">
                            <div class="error-404-inner">
                                <header>
                                    <h2 class="title-404">404</h2>
                                    <?php if(!empty($sub_title_404)) { ?>
                                        <h5 class="sub-title-404">
                                            <?php echo wp_kses_post($sub_title_404);?>
                                        </h5>
                                    <?php } else { ?>
                                        <h5 class="sub-title-404">
                                            <?php echo esc_html__('Page Not Found.', 'nuvo');?>
                                        </h5> 
                                    <?php } ?>
                                </header><!-- .page-title -->
                                <div class="page-content">
                                    <?php if(!empty($content_404_page)) {
                                        echo wp_kses_post($content_404_page);
                                    } else {
                                        echo esc_html__("The page you are looking for doesn't exist. It may have been moved or removed altogether. Please try searching for some other page, or return to the website's homepage to find what you're looking for.", "nuvo");
                                    } ?>
                                </div><!-- .page-content -->
                                <a class="btn btn-default wow fadeInRight" href="<?php echo esc_url(home_url('/')); ?>">
                                    <?php if(!empty($btn_text_404_page)) {
                                        echo wp_kses_post($btn_text_404_page);
                                    } else {
                                        echo esc_html__('Back To Home', 'nuvo');
                                    } ?>   
                                </a>
                            </div>
                        </section><!-- .error-404 -->
                    </div>
                </div>
            </div>
        </main><!-- #main -->
    </div><!-- #primary -->

<?php
get_footer();
