<?php
etc_add_custom_widget(
    array(
        'name' => 'cms_phone_ring',
        'title' => esc_html__('Phone Ring', 'nuvo'),
        'icon' => 'eicon-headphones',
        'categories' => array(Elementor_Theme_Core::ETC_CATEGORY_NAME),
        'params' => array(
            'sections' => array(
                array(
                    'name' => 'layout_section',
                    'label' => esc_html__('Layout', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
                    'controls' => array(
                        array(
                            'name' => 'layout',
                            'label' => esc_html__('Templates', 'nuvo' ),
                            'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
                            'default' => '1',
                            'options' => [
                                '1' => [
                                    'label' => esc_html__('Layout 1', 'nuvo' ),
                                    'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_phone_ring/layout-image/layout1.jpg'
                                ],

                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_text_box',
                    'label' => esc_html__('Phone Ring', 'nuvo'),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'phone',
                            'label' => esc_html__('Number Phone', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                            'placeholder' => esc_html__('Enter your Number Phone', 'nuvo' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'phone_link',
                            'label' => esc_html__('Phone Link', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '#',
                            'placeholder' => esc_html__('Enter your Link Phone', 'nuvo' ),
                            'label_block' => true,
                        ),
                        array(
                            'name' => 'phone_color',
                            'label' => esc_html__('Phone Color', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .cms-phone-ring .text-number a' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .cms-phone-ring .text-number' => 'color: {{VALUE}};',
                            ],
                        ),
                        array(
                            'name' => 'heading_typography',
                            'type' => \Elementor\Group_Control_Typography::get_type(),
                            'control_type' => 'group',
                            'selector' => '{{WRAPPER}} .box-title',
                        ),
                    ),
                ),
                array(
                    'name' => 'button_section',
                    'label' => esc_html__('Button', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                    'controls' => array(
                        array(
                            'name' => 'button_text',
                            'label' => esc_html__('Button Text', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '',
                        ),
                        array(
                            'name' => 'link',
                            'label' => esc_html__('Link', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::URL,
                            'placeholder' => esc_html__('https://your-link.com', 'nuvo' ),
                            'default' => [
                                'url' => '#',
                            ],
                        ),
                    ),
                ),
                array(
                    'name' => 'section_animation',
                    'label' => esc_html__('Title Style', 'nuvo' ),
                    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                    'controls' => array(
                        array(
                            'name' => 'cms_animate',
                            'label' => esc_html__('Theme Animate', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::SELECT,
                            'options' => nuvo_animate(),
                            'default' => '',
                        ),
                        array(
                            'name' => 'cms_animate_delay',
                            'label' => esc_html__('Animate Delay', 'nuvo' ),
                            'type' => \Elementor\Controls_Manager::TEXT,
                            'default' => '0',
                            'description' => 'Enter number. Default 0ms',
                        ),
                    ),
                ),          
            ),
        ),
    ),
    get_template_directory() . '/elementor/core/widgets/'
);