<?php

class ETC_CmsGoogleMap_Widget extends Elementor_Theme_Core_Widget_Base{
    protected $name = 'cms_google_map';
    protected $title = 'Google Maps';
    protected $icon = 'eicon-google-maps';
    protected $categories = array( 'elementor-theme-core' );
    protected $params = '{"sections":[{"name":"layout_section","label":"Layout","tab":"layout","controls":[{"name":"layout","label":"Templates","type":"layoutcontrol","default":"1","options":{"1":{"label":"Layout 1","image":"https:\/\/mapogos.kriacao.pt\/wp-content\/themes\/nuvo\/elementor\/templates\/widgets\/cms_google_map\/layout-image\/layout1.jpg"},"2":{"label":"Layout 2","image":"https:\/\/mapogos.kriacao.pt\/wp-content\/themes\/nuvo\/elementor\/templates\/widgets\/cms_google_map\/layout-image\/layout2.jpg"}}}]},{"name":"source_section","label":"Source Settings","tab":"content","controls":[{"name":"address","label":"Address","type":"text"},{"name":"coordinate","label":"Coordinate","type":"text","default":"51.505858, -0.123633"},{"name":"infoclick","label":"Click Show Info Window","type":"switcher"},{"name":"markercoordinate","label":"Marker Coordinate","type":"text","description":"Enter marker coordinate of Map, format input (latitude, longitude)"},{"name":"markertitle","label":"Marker Title","type":"text"},{"name":"markerdesc","label":"Marker Description","type":"textarea","description":"Enter Description Info windows for marker"},{"name":"markericon","label":"Marker Icon","type":"media","description":"Select image icon for marker"},{"name":"markerlist","label":"Marker List","type":"repeater","controls":[{"name":"coordinate","label":"Coordinate","type":"text"},{"name":"title","label":"Title","type":"text"},{"name":"desc","label":"Description","type":"textarea"}]},{"name":"infowidth","label":"Info Window Max Width","type":"text","description":"Set max width for info window"},{"name":"type","label":"Map Type","type":"select","options":{"ROADMAP":"ROADMAP","HYBRID":"HYBRID","SATELLITE":"SATELLITE","TERRAIN":"TERRAIN"},"default":"ROADMAP","description":"Select the map type."},{"name":"style","label":"Style Template","type":"select","options":{"":"Google Default","light-monochrome":"Light Monochrome","blue-water":"Blue water","midnight-commander":"Midnight Commander","paper":"Paper","red-hues":"Red Hues","hot-pink":"Hot Pink","custom":"Custom"},"default":"","description":"Select the map template."},{"name":"content","label":"Custom Template","type":"code","language":"json","description":"Get template from \/\/snazzymaps.com","condition":{"style":"custom"}},{"name":"zoom","label":"Zoom","type":"text","default":13,"description":"Set max width for info window"},{"name":"width","label":"Width","type":"text","default":"auto","description":"Width of map without pixel, default is auto"},{"name":"height","label":"Height","type":"text","default":"350px","description":"Height of map without pixel, default is 350px"},{"name":"scrollwheel","label":"Scroll Wheel","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"pancontrol","label":"Pan Control","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"zoomcontrol","label":"Zoom Control","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"scalecontrol","label":"Scale Control","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"maptypecontrol","label":"Map Type Control","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"streetviewcontrol","label":"Street View Control","type":"switcher","description":"Height of map without pixel, default is 350px"},{"name":"overviewmapcontrol","label":"Over View Map Control","type":"switcher","description":"Height of map without pixel, default is 350px"}]},{"name":"title_section","label":"Heading Layout","tab":"content","condition":{"layout":["2"]},"controls":[{"name":"heading_text","label":"Heading","type":"textarea","default":"This is the heading","placeholder":"Enter your title","label_block":true},{"name":"heading_size","label":"Heading HTML Tag","type":"select","options":{"h1":"H1","h2":"H2","h3":"H3","h4":"H4","h5":"H5","h6":"H6","div":"div","span":"span","p":"p"},"default":"h3"},{"name":"heading_color","label":"Heading Color","type":"color","selectors":{"{{WRAPPER}} .custom-heading":"color: {{VALUE}};"}},{"name":"heading_bottom_space","label":"Bottom Spacing","type":"slider","control_type":"responsive","size_units":["px"],"default":{"size":15},"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .custom-heading":"margin-bottom: {{SIZE}}{{UNIT}};"}},{"name":"heading_typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .custom-heading"},{"name":"text_align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"}},"selectors":{"{{WRAPPER}} .custom-heading":"text-align: {{VALUE}};"}},{"name":"sub_title","label":"Sub Heading","type":"textarea","placeholder":"Enter your Sub Heading","label_block":true}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'maps-googleapis','custom-gm-widget-js' );
}