<?php
$default_settings = [
    'cms_animate' => '',
    'title_text' => '',
    'button_text' => '',
    'button_link' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
$html_id = etc_get_element_id($settings);

$widget->add_render_attribute( 'description_text', 'class', 'custom-description' );
$widget->add_inline_editing_attributes( 'description_text' );

$time_to = $settings['time_to'];


if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

if ( ! empty( $button_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $button_link['url'] );

    if ( $button_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $button_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}

?>
<div class="cms-count-down layout4">
    <div class="inner-layout">
        <?php if ( $image_html ) : ?>
            <div class="col-banner">
                <?php echo wp_kses_post($image_html); ?>
            </div>
        <?php endif; ?>
        <div class="col-content <?php echo esc_attr($cms_animate); ?>" data-wow-delay="<?php echo esc_attr($settings['cms_animate_delay']); ?>ms">
            <div class="item-box-title">
                <?php if(!empty($settings['title_text'])) : ?>
                    <h3 class="item--title">
                        <?php echo wp_kses_post($settings['title_text']); ?>
                    </h3>
                    <span class="item-round"></span>
                <?php endif; ?>
                <?php if(!empty($settings['description_text'])) : ?>
                    <div <?php etc_print_html($widget->get_render_attribute_string( 'description_text' )); ?>>
                        <?php echo wp_kses_post($settings['description_text']); ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="cms-count-down-container font-smooth" data-time="<?php echo esc_attr($time_to); ?>">
                <div class="time-item">
                    <div class="inner-text"><?php echo esc_html__('Days', 'nuvo') ?></div>
                    <div class="day inner-number"></div>
                </div>
                <div class="time-item">
                    <div class="inner-text"><?php echo esc_html__('Hours', 'nuvo') ?></div>
                    <div class="hour inner-number"></div>
                </div>
                <div class="time-item">
                    <div class="inner-text"><?php echo esc_html__('Minutes', 'nuvo') ?></div>
                    <div class="minute inner-number"></div>
                </div>
                <div class="time-item">
                    <div class="inner-text"><?php echo esc_html__('Seconds', 'nuvo') ?></div>
                    <div class="second inner-number"></div>
                </div>
            </div>
            <?php if (!empty( $button_text )): ?>
                <div class="wp-buttom">
                    <a class="btn-book" <?php etc_print_html($widget->get_render_attribute_string( 'button' )); ?>>
                        <?php echo esc_attr($settings['button_text']); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
