<?php
$default_settings = [
    'menu_list' => '',
    'cms_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

$icon_tag = 'span';
$has_heading = ! empty( $settings['heading_text'] );
$widget->add_render_attribute( 'subheading_text', 'class', [
    'custom-subheading',
] );
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_inline_editing_attributes( 'subheading_text' );

?>

<div class="cms-menu-list layout1">
    <div class="cms-grid-inner">        
        <?php if(isset($menu_list) && !empty($menu_list) && count($menu_list)): ?>
            <?php foreach ($menu_list as $key => $value):
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $value['link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                    if ( $value['link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );

    			$title = isset($value['title']) ? $value['title'] : '';
                $description = isset($value['description']) ? $value['description'] : '';
                $price = isset($value['price']) ? $value['price'] : '';
                $feature_text = isset($value['feature_text']) ? $value['feature_text'] : '';
                $btn1 = isset($value['btn1']) ? $value['btn1'] : '';
                $btn1_text = isset($value['btn1_text']) ? $value['btn1_text'] : '';
                
                $btn2 = isset($value['btn2']) ? $value['btn2'] : '';
                $btn2_text = isset($value['btn2_text']) ? $value['btn2_text'] : '';
            	?>
                <div class="menu-item <?php echo esc_attr($cms_animate); ?>">
                    <?php if(!empty($title)) { ?>
                        <h3 class="item-name">
                            <?php if (!empty($link_attributes)){ ?><a <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php } ?>
                                <?php echo wp_kses_post( $title ); ?>
                            <?php if (!empty($link_attributes)){ ?></a><?php } ?>
                        </h3>
                    <?php } ?>
                    <?php if(!empty( $description )) { ?>
                        <div class="item-description"><?php echo wp_kses_post( $description ); ?></div>
                    <?php } ?>
                    <?php if(!empty( $price )) { ?>
                        <span class="item-price"><?php echo esc_attr( $price ); ?></span>
                    <?php } ?>
                    <div class="item-meta">
                        <?php if(!empty($feature_text)) { ?>
                            <div class="feature-popular">
                                <div class="wp-feature">
                                    <span><?php echo esc_attr($feature_text); ?></span>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="feature-excerpt">
                            <?php if(!empty($btn1) || !empty($btn1_text)) { ?>
                                <div class="button-tooltip btn-1">
                                    <?php echo esc_attr( $btn1 ); ?>
                                    <?php if(!empty($btn1_text)) { ?>
                                        <div class="content-tooltip"><?php echo esc_attr( $btn1_text ); ?></div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                            <?php if(!empty($btn2) || !empty($btn2_text)) { ?>
                                <div class="button-tooltip btn-2">
                                    <?php echo esc_attr( $btn2 ); ?>
                                    <?php if(!empty($btn2_text)) { ?>
                                        <div class="content-tooltip"><?php echo esc_attr( $btn2_text ); ?></div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>