<?php 
$default_settings = [
    'img_type' => 'img',
    'style' => 'style1',
    'image_s2' => '',
    'video_label' => '',
    'btn_text' => '',
    'cms_animate' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}

$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

?>
<div class="cms-video-player <?php echo esc_attr($style); ?> <?php echo esc_attr($cms_animate); ?>">
    <?php if(!empty($image_s2['id'])) {
        $img_s2  = etc_get_image_by_size( array(
            'attach_id'  => $image_s2['id'],
            'thumb_size' => 'full',
            'class'      => 'img-style2',
        ) );
        $img_thumbnail    = $img_s2['thumbnail'];
        echo wp_kses_post($img_thumbnail); 
    } ?>

    <?php if($style == 'style1') : ?>
        <?php if($img_type == 'bg') { ?>
            <div class="cms-video-bg-image bg-image" style="background-image: url(<?php echo esc_url($settings['image']['url']); ?>);"></div>
        <?php } else { ?>
            <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($image_html); } ?>
        <?php } ?>
        <div class="btn-video-wrap">
            <a class="btn-video" href="<?php echo esc_url($settings['video_link']); ?>">
                <i class="fac fac-play"></i>
                <span class="line-video-animation"></span>
                <span class="line-video-2 line-video-animation"></span>
                <span class="line-video-3 line-video-animation"></span>
            </a>
            <?php if(!empty($btn_text)) : ?>
                <span class="btn-video-text"><?php echo esc_attr($btn_text); ?></span>
            <?php endif; ?>
        </div>
        <div class="video-overlay"></div>
    <?php endif; ?>
</div>