<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Nuvo
 */
$post_tags_on = nuvo_get_opt( 'post_tags_on', true );
$post_navigation_on = nuvo_get_opt( 'post_navigation_on', false );
$post_author_info_on = nuvo_get_opt( 'post_author_info_on', false );
$post_social_share_on = nuvo_get_opt( 'post_social_share_on', false );
$post_feature_image_on = nuvo_get_opt( 'post_feature_image_on', true );
$post_date_on = nuvo_get_opt( 'post_date_on', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-hentry'); ?>>
    <div class="wp-title">
        <div class="wp-meta-top">
            <?php if($post_date_on) : ?>
                <span class="item-date">
                    <span class="date1"><?php echo get_the_date('j'); ?></span>
                    <span class="date2"><?php echo get_the_date('M'); ?></span>
                </span>
            <?php endif; ?>
            <div class="meta-icon">
                <i class="<?php if(is_sticky()){ echo "fa fa-thumb-tack"; } else { echo nuvo_get_icon_post_type();} ?>"></i>
            </div>
        </div>            
        <h2 class="entry-title">
            <?php the_title(); ?>
        </h2>
    </div>

    <?php if (has_post_thumbnail() && $post_feature_image_on == true) {
        echo '<div class="entry-featured entry-image"><div class="post-image">'; ?>
            <?php the_post_thumbnail('nuvo-large'); ?>
        <?php echo '</div></div>';
    } ?>
    <div class="entry-body">
        <?php nuvo_post_meta(); ?>
        <div class="entry-content clearfix">
            <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div><!-- .entry-content -->
    </div>
    <?php if($post_social_share_on) {
        nuvo_socials_share_default();
    } ?>
</article><!-- #post -->