<?php
/**
 * Template part for displaying default header layout
 */
$page_one_page = nuvo_get_page_opt( 'page_one_page');

$sticky_on = nuvo_get_opt( 'sticky_on', false );

$h_btn_on = nuvo_get_opt( 'h_btn_on', 'hide' );
$h_btn_text = nuvo_get_opt( 'h_btn_text' );
$h_btn_link_type = nuvo_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = nuvo_get_opt( 'h_btn_link' );
$h_btn_link_custom = nuvo_get_opt( 'h_btn_link_custom' );
$h_btn_target = nuvo_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}
$btn_icon2 = nuvo_get_opt( 'btn_icon2' );
$revslider = nuvo_get_page_opt( 'revslider', '');
?>
<header id="masthead" class="site-header">
    <?php if(!empty($revslider) && class_exists('RevSliderSlider') && function_exists('add_revslider')): ?>
        <div class="site-revolution">
            <?php add_revslider($revslider); ?>
        </div>
    <?php endif; ?>
    <div id="site-header-wrap" class="header-layout3 <?php if($sticky_on == 1) { echo 'is-sticky'; } ?> <?php if(isset($page_one_page) && $page_one_page) { echo 'active-menu-onepage'; }?>">
        <div id="site-header" class="site-header-main">
            <div class="container">
                <div class="row">
                    <div class="site-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="site-navigation">
                        <nav class="main-navigation">
                            <?php get_template_part( 'template-parts/header-menu' ); ?>
                        </nav>
                    </div>
                    <?php if (class_exists('ReduxFramework')) { ?>
                        <?php if($h_btn_on == 'show') : ?>
                            <div class="site-header-button">
                                <a class="btn-header" href="<?php echo esc_url($h_btn_url); ?>" target="<?php echo esc_attr($h_btn_target); ?>">
                                    <?php if(!empty($btn_icon2)) : ?>
                                        <i class="<?php echo esc_attr($btn_icon2); ?>"></i>
                                    <?php endif; ?>
                                    <?php echo esc_attr($h_btn_text); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php } ?>
                </div>
            </div>
            <div id="main-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>