<?php
$titles = nuvo_get_page_titles();
$pagetitle = nuvo_get_opt( 'pagetitle', 'show' );
$ptitle_layout = nuvo_get_opt( 'ptitle_layout', '1' );

$page_title_img = nuvo_get_opt( 'page_title_img' );

$breadcrumb = nuvo_get_opt( 'breadcrumb', 'show' );
$page_breadcrumb = nuvo_get_page_opt( 'page_breadcrumb', 'themeoption');

$custom_pagetitle = nuvo_get_page_opt( 'custom_pagetitle', 'themeoption');
$ptitle_layout_page = nuvo_get_page_opt( 'ptitle_layout', '');

if($custom_pagetitle != 'themeoption' && $custom_pagetitle != '') {
    $pagetitle = $custom_pagetitle;
}

if($custom_pagetitle != 'themeoption' && $custom_pagetitle != '' && $ptitle_layout_page != '') {
    $ptitle_layout = $ptitle_layout_page;
}

if($custom_pagetitle == 'show' && $page_breadcrumb != 'themeoption') {
    $breadcrumb = $page_breadcrumb;
}

$sub_title = nuvo_get_page_opt( 'sub_title' );

ob_start();
if ( $titles['title'] )
{
    printf( '<h1 class="entry-page-title">%s</h1>', wp_kses_post($titles['title']) );
}

$page_title_align = nuvo_get_page_opt( 'page_title_align', 'center' );
if(empty($page_title_align)){
    $page_title_align = nuvo_get_opt( 'page_title_align', 'center' );
}

$titles_html = ob_get_clean();

if($pagetitle == 'show') : ?>
    <?php 
        switch ($ptitle_layout) {
            case '4': ?>
                <div id="pagetitle" class="page-title page-title-layout4 breadcrumb-<?php echo esc_attr($breadcrumb); ?>">
                    <div class="container">
                        <div class="page-title-inner">
                            <div class="page-title-holder">
                                <?php printf( '%s', wp_kses_post($titles_html)); ?>
                            </div>
                            <div class="page-title-meta">
                                <?php if(!empty($sub_title)) : ?>
                                    <h6 class="page-sub-title"><?php echo esc_attr($sub_title); ?></h6>
                                <?php endif; ?>
                                <?php if($breadcrumb == 'show') { ?>
                                    <?php nuvo_breadcrumb(); ?>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php break;
            case '3': ?>
                <div id="pagetitle" class="page-title page-title-layout3 breadcrumb-<?php echo esc_attr($breadcrumb); ?>">
                    <div class="container">
                        <div class="page-title-inner" <?php if($page_title_align):?> style="text-align: <?php echo esc_attr($page_title_align);?>"<?php endif;?>>
                            <?php printf( '%s', wp_kses_post($titles_html)); ?>
                            <?php if(!empty($sub_title) || $breadcrumb == 'show' ) { ?>
                                <div class="page-title-meta">
                                    <?php if(!empty($sub_title)) : ?>
                                        <h6 class="page-sub-title"><?php echo esc_attr($sub_title); ?></h6>
                                    <?php endif; ?>
                                    <?php if($breadcrumb == 'show') { ?>
                                        <?php nuvo_breadcrumb(); ?>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php break;
            case '2': ?>
                <div id="pagetitle" class="page-title page-title-layout2 breadcrumb-<?php echo esc_attr($breadcrumb); ?>" <?php if(!empty($page_title_img['url'])) : ?>style="background-image: url(<?php echo esc_url($page_title_img['url']); ?>);"<?php endif; ?>>
                    <div class="container">
                        <div class="page-title-inner">
                            <div class="page-title-holder">
                                <?php printf( '%s', wp_kses_post($titles_html)); ?>
                            </div>
                            <div class="page-title-meta">
                                <?php if(!empty($sub_title)) : ?>
                                    <h6 class="page-sub-title"><?php echo esc_attr($sub_title); ?></h6>
                                <?php endif; ?>
                                <?php if($breadcrumb == 'show') { ?>
                                    <?php nuvo_breadcrumb(); ?>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php break;
            default: ?>
                <div id="pagetitle" class="page-title bg-image page-title-layout1 breadcrumb-<?php echo esc_attr($breadcrumb); ?>" <?php if(!empty($page_title_img['url'])) : ?>style="background-image: url(<?php echo esc_url($page_title_img['url']); ?>);"<?php endif; ?>>
                    <div class="container">
                        <div class="page-title-inner" <?php if($page_title_align):?> style="text-align: <?php echo esc_attr($page_title_align);?>"<?php endif;?>>
                            <?php printf( '%s', wp_kses_post($titles_html)); ?>
                            <?php if(!empty($sub_title) || $breadcrumb == 'show' ) : ?>
                                <div class="page-title-meta">
                                    <?php if(!empty($sub_title)) : ?>
                                        <h6 class="page-sub-title"><?php echo esc_attr($sub_title); ?></h6>
                                    <?php endif; ?>
                                    <?php if($breadcrumb == 'show') : ?>
                                        <?php nuvo_breadcrumb(); ?>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php break;
        }
    ?>
<?php endif; ?>